# Smart Friend - Deployment Guide

## Owner: Engineer S M Nazrul Islam Tasnim (HQ)

## Local Development

### 1. Install Dependencies
```bash
npm install
```

### 2. Configure Environment
```bash
cp .env.example .env
```

Edit `.env` and add your API keys (these are auto-configured in Lovable):
- VITE_SUPABASE_URL
- VITE_SUPABASE_PUBLISHABLE_KEY
- VITE_SUPABASE_PROJECT_ID

### 3. Run Development Server
```bash
npm run dev
```

## Production Build

### 1. Build the Project
```bash
npm run build
```

This creates a `/dist` folder with production-ready files.

## Hosting on cPanel (Shared Hosting)

### Step 1: Upload Files
1. Build the project locally: `npm run build`
2. Access your cPanel File Manager
3. Navigate to `public_html/smartfriend` (or your desired folder)
4. Upload all files from the `/dist` folder

### Step 2: Configure Environment Variables
- Environment variables are pre-configured in the build
- No additional configuration needed for Lovable Cloud projects

### Step 3: Set Base URL (if using subfolder)
In your Vite config, ensure:
```javascript
base: '/smartfriend/' // if hosted in a subfolder
```

## Hosting on Netlify

1. Connect your GitHub repository
2. Build command: `npm run build`
3. Publish directory: `dist`
4. Environment variables are auto-configured

## Hosting on Vercel

1. Import your GitHub repository
2. Framework: Vite
3. Build command: `npm run build`
4. Output directory: `dist`
5. Environment variables are auto-configured

## Features Included

### AI Brain Engine
- Context memory (short-term + long-term)
- Task planning and execution
- Web search integration
- Owner: Engineer Tasnim

### Dynamic Module System
- Auto-loading modules from /modules folder
- Module enable/disable
- AI-powered module generation

### Voice System
- Voice input (Speech Recognition)
- Voice output (Text-to-Speech)
- 3 voice profiles: Male, Female, Neutral

### ZIP Export
- One-click production package export
- Includes deployment instructions
- Ready for any hosting platform

## Security

Only the owner (Engineer Tasnim) can:
- Access Brain Console
- Manage modules
- Export production packages
- View deployment settings

## Troubleshooting

### Build Errors
- Clear cache: `rm -rf node_modules && npm install`
- Force rebuild: `npm run build -- --force`

### Routing Issues
- Ensure hosting supports SPA routing
- Add `_redirects` file for Netlify
- Add `vercel.json` for Vercel

## Support
For issues or questions, contact: engineer.tasnim@smartseba.com
