import { Toaster } from "@/components/ui/toaster";
import { Toaster as Sonner } from "@/components/ui/sonner";
import { TooltipProvider } from "@/components/ui/tooltip";
import { QueryClient, QueryClientProvider } from "@tanstack/react-query";
import { BrowserRouter, Routes, Route } from "react-router-dom";
import { ThemeProvider } from "@/components/ThemeProvider";
import { LanguageProvider } from "@/hooks/useLanguage";
import Index from "./pages/Index";
import Auth from "./pages/Auth";
import Chat from "./pages/Chat";
import Contacts from "./pages/Contacts";
import CallHistory from "./pages/CallHistory";
import Modules from "./pages/Modules";
import CoreBrain from "./pages/CoreBrain";
import SmartPay from "./pages/SmartPay";
import Profile from "./pages/Profile";
import CodeBuilder from "./pages/CodeBuilder";
import SmartFriendStudio from "./pages/SmartFriendStudio";
import Studio from "./pages/Studio";
import StudioIDE from "./pages/StudioIDE";
import StudioAIEngine from "./pages/StudioAIEngine";
import StudioModules from "./pages/StudioModules";
import StudioDesigner from "./pages/StudioDesigner";
import StudioMemory from "./pages/StudioMemory";
import StudioWallet from "./pages/StudioWallet";
import StudioSubscription from "./pages/StudioSubscription";
import StudioDeploy from "./pages/StudioDeploy";
import StudioAffiliate from "./pages/StudioAffiliate";
import StudioSearch from "./pages/StudioSearch";
import StudioSearchSettings from "./pages/StudioSearchSettings";
import StudioMarketplace from "./pages/StudioMarketplace";
import StudioAVA from "./pages/StudioAVA";
import StudioIntegration from "./pages/StudioIntegration";
import StudioAffiliateAnalytics from "./pages/StudioAffiliateAnalytics";
import StudioAnalytics from "./pages/StudioAnalytics";
import StudioSecuritySettings from "./pages/StudioSecuritySettings";
import StudioOfflineSettings from "./pages/StudioOfflineSettings";
import StudioDevOps from "./pages/StudioDevOps";
import StudioCall from "./pages/StudioCall";
import StudioClone from "./pages/StudioClone";
import StudioTasks from "./pages/StudioTasks";
import StudioErrors from "./pages/StudioErrors";
import StudioDocs from "./pages/StudioDocs";
import StudioCommand from "./pages/StudioCommand";
import StudioBuild from "./pages/StudioBuild";
import StudioDev from "./pages/StudioDev";
import StudioBuilder from "./pages/StudioBuilder";
import BrainDemo from "./pages/BrainDemo";
import BrainConsole from "./pages/BrainConsole";
import ModulesManager from "./pages/ModulesManager";
import VoiceSettings from "./pages/VoiceSettings";
import DeploymentCenter from "./pages/DeploymentCenter";
import BuildExport from "./pages/BuildExport";
import SmartMarketer from "./pages/SmartMarketer";
import SmartDesignHub from "./pages/SmartDesignHub";
import SmartAcademy from "./pages/SmartAcademy";
import SmartDoctor from "./pages/SmartDoctor";
import SmartNews from "./pages/SmartNews";
import SmartBazar from "./pages/SmartBazar";
import SmartTourist from "./pages/SmartTourist";
import SmartJob from "./pages/SmartJob";
import SmartCallCenter from "./pages/SmartCallCenter";
import SmartAdFirm from "./pages/SmartAdFirm";
import SmartSchool from "./pages/SmartSchool";
import SmartLawyer from "./pages/SmartLawyer";
import Landing from "./pages/Landing";
import SebaHome from "./pages/SebaHome";
import ModuleDetail from "./pages/ModuleDetail";
import HQDashboard from "./pages/HQDashboard";
import HQModuleEdit from "./pages/HQModuleEdit";
import Onboarding from "./pages/Onboarding";
import CountrySettings from "./pages/CountrySettings";
import NotFound from "./pages/NotFound";
import Settings from "./pages/Settings";
import FutureFeatures from "./pages/FutureFeatures";
import { PWAInstallBanner } from "./components/PWAInstallBanner";
import ProtectedRoute from "./components/ProtectedRoute";
import CoreBrainProtectedRoute from "./components/CoreBrainProtectedRoute";
import BottomNav from "./components/BottomNav";
import { useAuth } from "./hooks/useAuth";
import { OwnerGuard } from "./components/OwnerGuard";

const queryClient = new QueryClient();

const AppContent = () => {
  const { user, loading } = useAuth();

  if (loading) {
    return (
      <div className="flex items-center justify-center min-h-screen">
        <div className="text-4xl">🤖</div>
      </div>
    );
  }

  return (
    <>
      <div className="min-h-screen pb-16">
        <Routes>
          <Route path="/seba" element={<SebaHome />} />
          <Route path="/module/:slug" element={<ModuleDetail />} />
          <Route path="/hq" element={<OwnerGuard><HQDashboard /></OwnerGuard>} />
          <Route path="/hq/modules/:id" element={<OwnerGuard><HQModuleEdit /></OwnerGuard>} />
          <Route path="/landing" element={<Landing />} />
          <Route path="/onboarding" element={<Onboarding />} />
          <Route path="/country-settings" element={<CountrySettings />} />
          <Route path="/auth" element={<Auth />} />
          <Route path="/build-export" element={<BuildExport />} />
          <Route
            path="/"
            element={
              <ProtectedRoute>
                <Index />
              </ProtectedRoute>
            }
          />
          <Route
            path="/chat"
            element={
              <ProtectedRoute>
                <Chat />
              </ProtectedRoute>
            }
          />
          <Route
            path="/contacts"
            element={
              <ProtectedRoute>
                <Contacts />
              </ProtectedRoute>
            }
          />
          <Route
            path="/call-history"
            element={
              <ProtectedRoute>
                <CallHistory />
              </ProtectedRoute>
            }
          />
          <Route
            path="/modules"
            element={
              <ProtectedRoute>
                <Modules />
              </ProtectedRoute>
            }
          />
          <Route
            path="/core-brain"
            element={
              <CoreBrainProtectedRoute>
                <CoreBrain />
              </CoreBrainProtectedRoute>
            }
          />
          <Route
            path="/smart-pay"
            element={
              <ProtectedRoute>
                <SmartPay />
              </ProtectedRoute>
            }
          />
          <Route
            path="/profile"
            element={
              <ProtectedRoute>
                <Profile />
              </ProtectedRoute>
            }
          />
          <Route
            path="/code-builder"
            element={
              <ProtectedRoute>
                <CodeBuilder />
              </ProtectedRoute>
            }
          />
          <Route
            path="/studio"
            element={
              <ProtectedRoute>
                <SmartFriendStudio />
              </ProtectedRoute>
            }
          />
          <Route
            path="/studio-v2"
            element={
              <ProtectedRoute>
                <OwnerGuard>
                  <Studio />
                </OwnerGuard>
              </ProtectedRoute>
            }
          />
          <Route
            path="/studio/ide"
            element={
              <ProtectedRoute>
                <OwnerGuard>
                  <StudioIDE />
                </OwnerGuard>
              </ProtectedRoute>
            }
          />
          <Route
            path="/studio/build"
            element={
              <ProtectedRoute>
                <OwnerGuard>
                  <StudioBuild />
                </OwnerGuard>
              </ProtectedRoute>
            }
          />
          <Route
            path="/brain-console"
            element={
              <ProtectedRoute>
                <OwnerGuard>
                  <BrainConsole />
                </OwnerGuard>
              </ProtectedRoute>
            }
          />
          <Route
            path="/modules"
            element={
              <ProtectedRoute>
                <OwnerGuard>
                  <ModulesManager />
                </OwnerGuard>
              </ProtectedRoute>
            }
          />
          <Route
            path="/voice-settings"
            element={
              <ProtectedRoute>
                <VoiceSettings />
              </ProtectedRoute>
            }
          />
          <Route
            path="/deployment"
            element={
              <ProtectedRoute>
                <OwnerGuard>
                  <DeploymentCenter />
                </OwnerGuard>
              </ProtectedRoute>
            }
          />
          <Route
            path="/studio/ai-engine"
            element={
              <ProtectedRoute>
                <OwnerGuard>
                  <StudioAIEngine />
                </OwnerGuard>
              </ProtectedRoute>
            }
          />
          <Route
            path="/studio/modules"
            element={
              <ProtectedRoute>
                <OwnerGuard>
                  <StudioModules />
                </OwnerGuard>
              </ProtectedRoute>
            }
          />
          <Route
            path="/studio/designer"
            element={
              <ProtectedRoute>
                <OwnerGuard>
                  <StudioDesigner />
                </OwnerGuard>
              </ProtectedRoute>
            }
          />
          <Route
            path="/studio/memory"
            element={
              <ProtectedRoute>
                <OwnerGuard>
                  <StudioMemory />
                </OwnerGuard>
              </ProtectedRoute>
            }
          />
          <Route
            path="/studio/wallet"
            element={
              <ProtectedRoute>
                <OwnerGuard>
                  <StudioWallet />
                </OwnerGuard>
              </ProtectedRoute>
            }
          />
          <Route
            path="/studio/devops"
            element={
              <ProtectedRoute>
                <OwnerGuard>
                  <StudioDevOps />
                </OwnerGuard>
              </ProtectedRoute>
            }
          />
          <Route
            path="/studio/call"
            element={
              <ProtectedRoute>
                <OwnerGuard>
                  <StudioCall />
                </OwnerGuard>
              </ProtectedRoute>
            }
          />
          <Route
            path="/studio/clone"
            element={
              <ProtectedRoute>
                <OwnerGuard>
                  <StudioClone />
                </OwnerGuard>
              </ProtectedRoute>
            }
          />
          <Route
            path="/studio/tasks"
            element={
              <ProtectedRoute>
                <OwnerGuard>
                  <StudioTasks />
                </OwnerGuard>
              </ProtectedRoute>
            }
          />
          <Route
            path="/studio/errors"
            element={
              <ProtectedRoute>
                <OwnerGuard>
                  <StudioErrors />
                </OwnerGuard>
              </ProtectedRoute>
            }
          />
          <Route
            path="/studio/dev"
            element={
              <ProtectedRoute>
                <OwnerGuard>
                  <StudioDev />
                </OwnerGuard>
              </ProtectedRoute>
            }
          />
          <Route
            path="/studio/builder"
            element={
              <ProtectedRoute>
                <OwnerGuard>
                  <StudioBuilder />
                </OwnerGuard>
              </ProtectedRoute>
            }
          />
          <Route
            path="/studio/docs"
            element={
              <ProtectedRoute>
                <OwnerGuard>
                  <StudioDocs />
                </OwnerGuard>
              </ProtectedRoute>
            }
          />
          <Route
            path="/studio/command"
            element={
              <ProtectedRoute>
                <OwnerGuard>
                  <StudioCommand />
                </OwnerGuard>
              </ProtectedRoute>
            }
          />
          <Route
            path="/studio/subscription"
            element={
              <ProtectedRoute>
                <OwnerGuard>
                  <StudioSubscription />
                </OwnerGuard>
              </ProtectedRoute>
            }
          />
          <Route
            path="/studio/deploy"
            element={
              <ProtectedRoute>
                <OwnerGuard>
                  <StudioDeploy />
                </OwnerGuard>
              </ProtectedRoute>
            }
          />
          <Route
            path="/studio/affiliate"
            element={
              <ProtectedRoute>
                <OwnerGuard>
                  <StudioAffiliate />
                </OwnerGuard>
              </ProtectedRoute>
            }
          />
          <Route
            path="/studio/search"
            element={
              <ProtectedRoute>
                <StudioSearch />
              </ProtectedRoute>
            }
          />
          <Route
            path="/studio/search/settings"
            element={
              <ProtectedRoute>
                <StudioSearchSettings />
              </ProtectedRoute>
            }
          />
          <Route
            path="/studio/marketplace"
            element={
              <ProtectedRoute>
                <OwnerGuard>
                  <StudioMarketplace />
                </OwnerGuard>
              </ProtectedRoute>
            }
          />
          <Route
            path="/studio/ava"
            element={
              <ProtectedRoute>
                <OwnerGuard>
                  <StudioAVA />
                </OwnerGuard>
              </ProtectedRoute>
            }
          />
          <Route
            path="/studio/integration"
            element={
              <ProtectedRoute>
                <OwnerGuard>
                  <StudioIntegration />
                </OwnerGuard>
              </ProtectedRoute>
            }
          />
          <Route
            path="/studio/affiliate-analytics"
            element={
              <ProtectedRoute>
                <OwnerGuard>
                  <StudioAffiliateAnalytics />
                </OwnerGuard>
              </ProtectedRoute>
            }
          />
          <Route
            path="/studio/analytics"
            element={
              <ProtectedRoute>
                <OwnerGuard>
                  <StudioAnalytics />
                </OwnerGuard>
              </ProtectedRoute>
            }
          />
          <Route
            path="/studio/security"
            element={
              <ProtectedRoute>
                <OwnerGuard>
                  <StudioSecuritySettings />
                </OwnerGuard>
              </ProtectedRoute>
            }
          />
          <Route
            path="/studio/offline"
            element={
              <ProtectedRoute>
                <OwnerGuard>
                  <StudioOfflineSettings />
                </OwnerGuard>
              </ProtectedRoute>
            }
          />
          
          {/* Phase 3: Smart Seba Modules */}
          <Route
            path="/smart-marketer"
            element={
              <ProtectedRoute>
                <SmartMarketer />
              </ProtectedRoute>
            }
          />
          <Route
            path="/smart-design"
            element={
              <ProtectedRoute>
                <SmartDesignHub />
              </ProtectedRoute>
            }
          />
          <Route
            path="/smart-academy"
            element={
              <ProtectedRoute>
                <SmartAcademy />
              </ProtectedRoute>
            }
          />
          <Route
            path="/smart-doctor"
            element={
              <ProtectedRoute>
                <SmartDoctor />
              </ProtectedRoute>
            }
          />
          <Route
            path="/smart-news"
            element={
              <ProtectedRoute>
                <SmartNews />
              </ProtectedRoute>
            }
          />
          <Route
            path="/smart-bazar"
            element={
              <ProtectedRoute>
                <SmartBazar />
              </ProtectedRoute>
            }
          />
          <Route
            path="/smart-tourist"
            element={
              <ProtectedRoute>
                <SmartTourist />
              </ProtectedRoute>
            }
          />
          <Route
            path="/smart-job"
            element={
              <ProtectedRoute>
                <SmartJob />
              </ProtectedRoute>
            }
          />
          <Route
            path="/smart-call-center"
            element={
              <ProtectedRoute>
                <SmartCallCenter />
              </ProtectedRoute>
            }
          />
          <Route
            path="/smart-ad-firm"
            element={
              <ProtectedRoute>
                <SmartAdFirm />
              </ProtectedRoute>
            }
          />
          <Route
            path="/smart-school"
            element={
              <ProtectedRoute>
                <SmartSchool />
              </ProtectedRoute>
            }
          />
          <Route
            path="/smart-lawyer"
            element={
              <ProtectedRoute>
                <SmartLawyer />
              </ProtectedRoute>
            }
          />
          <Route
            path="/brain-demo"
            element={
              <ProtectedRoute>
                <BrainDemo />
              </ProtectedRoute>
            }
          />
          <Route path="*" element={<NotFound />} />
        </Routes>
      </div>
      {user && <BottomNav />}
    </>
  );
};

const App = () => (
  <QueryClientProvider client={queryClient}>
    <ThemeProvider defaultTheme="dark">
      <LanguageProvider>
        <TooltipProvider>
          <Toaster />
          <Sonner />
          <BrowserRouter>
            <AppContent />
          </BrowserRouter>
        </TooltipProvider>
      </LanguageProvider>
    </ThemeProvider>
  </QueryClientProvider>
);

export default App;
