import { NavLink } from "react-router-dom";
import { Home, Grid3x3, MessageSquare, User, Wallet } from "lucide-react";
import { useLanguage } from "@/hooks/useLanguage";

const BottomNav = () => {
  const { language } = useLanguage();
  
  const navItems = [
    { 
      to: "/", 
      icon: Home, 
      label: language === "bn" ? "হোম" : "Home"
    },
    { 
      to: "/modules", 
      icon: Grid3x3, 
      label: language === "bn" ? "মডিউল" : "Modules"
    },
    { 
      to: "/chat", 
      icon: MessageSquare, 
      label: language === "bn" ? "চ্যাট" : "Chat"
    },
    { 
      to: "/studio/wallet", 
      icon: Wallet, 
      label: language === "bn" ? "ওয়ালেট" : "Wallet"
    },
    { 
      to: "/profile", 
      icon: User, 
      label: language === "bn" ? "প্রোফাইল" : "Profile"
    },
  ];

  return (
    <nav className="fixed bottom-0 left-0 right-0 bg-background border-t z-50">
      <div className="flex justify-around items-center h-16">
        {navItems.map((item) => (
          <NavLink
            key={item.to}
            to={item.to}
            end
            className={({ isActive }) =>
              `flex flex-col items-center justify-center flex-1 h-full transition-colors ${
                isActive
                  ? "text-primary"
                  : "text-muted-foreground hover:text-foreground"
              }`
            }
          >
            {({ isActive }) => (
              <>
                <item.icon className={`h-5 w-5 ${isActive ? "fill-current" : ""}`} />
                <span className="text-xs mt-1 font-medium">
                  {item.label}
                </span>
              </>
            )}
          </NavLink>
        ))}
      </div>
    </nav>
  );
};

export default BottomNav;