import { useState } from "react";
import { Search, Loader2 } from "lucide-react";
import { Input } from "@/components/ui/input";
import {
  CommandDialog,
  CommandEmpty,
  CommandGroup,
  CommandInput,
  CommandItem,
  CommandList,
} from "@/components/ui/command";
import { useNavigate } from "react-router-dom";

interface SearchResult {
  id: string;
  title: string;
  category: string;
  route: string;
}

export const GlobalSearch = () => {
  const [open, setOpen] = useState(false);
  const [loading, setLoading] = useState(false);
  const navigate = useNavigate();

  const searchResults: SearchResult[] = [
    { id: "1", title: "Smart Academy", category: "Modules", route: "/smart-academy" },
    { id: "2", title: "Smart Doctor", category: "Modules", route: "/smart-doctor" },
    { id: "3", title: "Smart Bazar", category: "Modules", route: "/smart-bazar" },
    { id: "4", title: "Smart Pay", category: "Modules", route: "/smart-pay" },
    { id: "5", title: "Smart News", category: "Modules", route: "/smart-news" },
    { id: "6", title: "Smart Job", category: "Modules", route: "/smart-job" },
    { id: "7", title: "Smart Tourist", category: "Modules", route: "/smart-tourist" },
    { id: "8", title: "Smart Lawyer", category: "Modules", route: "/smart-lawyer" },
    { id: "9", title: "Studio IDE", category: "Studio", route: "/studio/ide" },
    { id: "10", title: "Studio Wallet", category: "Studio", route: "/studio/wallet" },
    { id: "11", title: "Analytics", category: "Studio", route: "/studio/analytics" },
    { id: "12", title: "Marketplace", category: "Studio", route: "/studio/marketplace" },
  ];

  const handleSelect = (route: string) => {
    setOpen(false);
    navigate(route);
  };

  return (
    <>
      <div className="relative">
        <Search className="absolute left-3 top-1/2 transform -translate-y-1/2 h-4 w-4 text-muted-foreground" />
        <Input
          placeholder="Search modules, pages..."
          className="pl-10 w-[300px]"
          onClick={() => setOpen(true)}
          readOnly
        />
      </div>

      <CommandDialog open={open} onOpenChange={setOpen}>
        <CommandInput placeholder="Type to search..." />
        <CommandList>
          <CommandEmpty>
            {loading ? (
              <div className="flex items-center justify-center py-6">
                <Loader2 className="h-6 w-6 animate-spin" />
              </div>
            ) : (
              "No results found."
            )}
          </CommandEmpty>
          
          {Object.entries(
            searchResults.reduce((acc, result) => {
              if (!acc[result.category]) acc[result.category] = [];
              acc[result.category].push(result);
              return acc;
            }, {} as Record<string, SearchResult[]>)
          ).map(([category, results]) => (
            <CommandGroup key={category} heading={category}>
              {results.map((result) => (
                <CommandItem
                  key={result.id}
                  onSelect={() => handleSelect(result.route)}
                >
                  {result.title}
                </CommandItem>
              ))}
            </CommandGroup>
          ))}
        </CommandList>
      </CommandDialog>
    </>
  );
};
