import { ReactNode } from "react";
import { useOwnerCheck } from "@/hooks/useOwnerCheck";
import { Alert, AlertDescription, AlertTitle } from "@/components/ui/alert";
import { Shield } from "lucide-react";

interface OwnerGuardProps {
  children: ReactNode;
}

export const OwnerGuard = ({ children }: OwnerGuardProps) => {
  const { isOwner, isAdmin, isLoading } = useOwnerCheck();

  if (isLoading) {
    return (
      <div className="h-screen flex items-center justify-center bg-background">
        <div className="text-center space-y-4">
          <div className="animate-spin rounded-full h-12 w-12 border-b-2 border-primary mx-auto" />
          <p className="text-muted-foreground">Verifying access...</p>
        </div>
      </div>
    );
  }

  if (!isOwner && !isAdmin) {
    return (
      <div className="h-screen flex items-center justify-center bg-gradient-to-br from-primary/5 via-background to-secondary/5 p-6">
        <Alert className="max-w-md">
          <Shield className="h-5 w-5" />
          <AlertTitle>Access Restricted</AlertTitle>
          <AlertDescription>
            This area is restricted to authorized administrators only.
            Please contact the system owner if you believe you should have access.
          </AlertDescription>
        </Alert>
      </div>
    );
  }

  return <>{children}</>;
};