import { SmartFriendIcon } from "./SmartFriendIcon";

export const SmartFriendHeader = () => {
  return (
    <div className="text-center space-y-4">
      <div className="flex justify-center mb-6">
        <SmartFriendIcon />
      </div>
      
      <div className="space-y-2">
        <h1 className="text-3xl sm:text-4xl md:text-5xl font-bold bg-gradient-to-r from-blue-600 via-purple-600 to-pink-600 bg-clip-text text-transparent leading-tight">
          Smart Friend (AVA)
        </h1>
        
        <p className="text-base sm:text-lg md:text-xl text-muted-foreground font-medium px-4">
          আপনার ব্যক্তিগত বুদ্ধিমান সহায়ক
        </p>
        
        <div className="flex items-center justify-center gap-2 pt-2">
          <div className="h-1 w-1 rounded-full bg-gradient-to-r from-blue-500 to-purple-500 animate-pulse" />
          <p className="text-xs sm:text-sm text-muted-foreground/80">
            Powered by SmartSeba.com
          </p>
          <div className="h-1 w-1 rounded-full bg-gradient-to-r from-purple-500 to-pink-500 animate-pulse" />
        </div>
      </div>
    </div>
  );
};
