import { Brain } from "lucide-react";

export const SmartFriendIcon = () => {
  return (
    <div className="relative inline-flex items-center justify-center">
      {/* Gradient background glow */}
      <div className="absolute inset-0 bg-gradient-to-br from-blue-500 via-purple-500 to-pink-500 rounded-full blur-xl opacity-40 animate-pulse" />
      
      {/* Icon container with gradient border */}
      <div className="relative bg-gradient-to-br from-blue-500 via-purple-500 to-pink-500 p-[3px] rounded-2xl">
        <div className="bg-background rounded-2xl p-4 sm:p-6">
          <Brain className="w-10 h-10 sm:w-12 sm:h-12 text-transparent bg-gradient-to-br from-blue-500 via-purple-500 to-pink-500 bg-clip-text" style={{
            filter: "drop-shadow(0 0 8px rgba(59, 130, 246, 0.5))"
          }} />
        </div>
      </div>
      
      {/* Sparkle effects */}
      <div className="absolute -top-1 -right-1 w-3 h-3 bg-gradient-to-br from-blue-400 to-pink-400 rounded-full animate-ping" />
      <div className="absolute -bottom-1 -left-1 w-2 h-2 bg-gradient-to-br from-purple-400 to-blue-400 rounded-full animate-pulse" />
    </div>
  );
};
