import {
  AlertDialog,
  AlertDialogAction,
  AlertDialogCancel,
  AlertDialogContent,
  AlertDialogDescription,
  AlertDialogFooter,
  AlertDialogHeader,
  AlertDialogTitle,
} from "@/components/ui/alert-dialog";
import { Phone, PhoneOff } from "lucide-react";

type IncomingCallModalProps = {
  isOpen: boolean;
  callerName: string;
  callType: "voice" | "video";
  onAccept: () => void;
  onDecline: () => void;
};

export const IncomingCallModal = ({
  isOpen,
  callerName,
  callType,
  onAccept,
  onDecline,
}: IncomingCallModalProps) => {
  return (
    <AlertDialog open={isOpen}>
      <AlertDialogContent>
        <AlertDialogHeader>
          <AlertDialogTitle className="text-center">
            {callType === "video" ? "📹" : "📞"} Incoming {callType} call
          </AlertDialogTitle>
          <AlertDialogDescription className="text-center text-lg">
            <div className="py-4">
              <p className="font-semibold text-foreground">{callerName}</p>
              <p className="text-sm text-muted-foreground mt-1">
                wants to {callType} call with you
              </p>
            </div>
          </AlertDialogDescription>
        </AlertDialogHeader>
        <AlertDialogFooter className="flex-row gap-2 sm:gap-2">
          <AlertDialogCancel
            onClick={onDecline}
            className="flex-1 bg-destructive text-destructive-foreground hover:bg-destructive/90"
          >
            <PhoneOff className="h-4 w-4 mr-2" />
            Decline
          </AlertDialogCancel>
          <AlertDialogAction
            onClick={onAccept}
            className="flex-1 bg-green-600 hover:bg-green-700"
          >
            <Phone className="h-4 w-4 mr-2" />
            Accept
          </AlertDialogAction>
        </AlertDialogFooter>
      </AlertDialogContent>
    </AlertDialog>
  );
};
