import { format, isToday, isYesterday } from "date-fns";

type DateSeparatorProps = {
  date: Date;
  isBangla: boolean;
};

export const DateSeparator = ({ date, isBangla }: DateSeparatorProps) => {
  const getDateText = () => {
    if (isToday(date)) {
      return isBangla ? "আজ" : "Today";
    }
    if (isYesterday(date)) {
      return isBangla ? "গতকাল" : "Yesterday";
    }
    return format(date, "MMMM dd, yyyy");
  };

  return (
    <div className="flex items-center justify-center my-4">
      <div className="bg-muted px-3 py-1 rounded-full">
        <span className="text-xs font-medium text-muted-foreground">
          {getDateText()}
        </span>
      </div>
    </div>
  );
};
