import { Badge } from "@/components/ui/badge";
import { useEmotionAI, EmotionType } from "@/hooks/useEmotionAI";
import { useLanguage } from "@/hooks/useLanguage";

interface EmotionBadgeProps {
  emotion: EmotionType;
  confidence: number;
}

export const EmotionBadge = ({ emotion, confidence }: EmotionBadgeProps) => {
  const { getEmotionColor, getEmotionLabel } = useEmotionAI();
  const { language } = useLanguage();

  if (emotion === "neutral" || confidence < 60) {
    return null;
  }

  return (
    <Badge className={`text-xs ${getEmotionColor(emotion)}`}>
      {getEmotionLabel(emotion, language)}
    </Badge>
  );
};
