import { Badge } from "@/components/ui/badge";
import { Loader2, Calendar, Cloud, Search } from "lucide-react";

type FunctionCallIndicatorProps = {
  functionName?: string;
  isExecuting?: boolean;
};

const functionIcons: Record<string, any> = {
  set_reminder: Calendar,
  get_weather: Cloud,
  search_web: Search,
};

const functionLabels: Record<string, string> = {
  set_reminder: "Setting Reminder",
  get_weather: "Checking Weather",
  search_web: "Searching Web",
};

export const FunctionCallIndicator = ({ 
  functionName, 
  isExecuting = false 
}: FunctionCallIndicatorProps) => {
  if (!functionName) return null;

  const Icon = functionIcons[functionName] || Loader2;
  const label = functionLabels[functionName] || "Executing";

  return (
    <Badge 
      variant="secondary" 
      className="gap-2 animate-pulse bg-primary/10 text-primary border-primary/20"
    >
      <Icon className="h-3 w-3" />
      {label}
      {isExecuting && <Loader2 className="h-3 w-3 animate-spin" />}
    </Badge>
  );
};
