import { Card } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Calendar, Cloud, Search, Sparkles } from "lucide-react";

type FunctionExamplesProps = {
  onExampleClick: (example: string) => void;
  isBangla: boolean;
};

export const FunctionExamples = ({ onExampleClick, isBangla }: FunctionExamplesProps) => {
  const examples = isBangla
    ? [
        {
          icon: Calendar,
          text: "আগামীকাল সকাল ১০টায় মিটিং এর জন্য একটি রিমাইন্ডার সেট করুন",
          color: "text-blue-500",
        },
        {
          icon: Cloud,
          text: "ঢাকার আবহাওয়া কেমন?",
          color: "text-cyan-500",
        },
        {
          icon: Search,
          text: "বাংলাদেশের সর্বশেষ খবর খুঁজুন",
          color: "text-purple-500",
        },
      ]
    : [
        {
          icon: Calendar,
          text: "Set a reminder for my meeting tomorrow at 10am",
          color: "text-blue-500",
        },
        {
          icon: Cloud,
          text: "What's the weather like in Dhaka?",
          color: "text-cyan-500",
        },
        {
          icon: Search,
          text: "Search for latest news about Bangladesh",
          color: "text-purple-500",
        },
      ];

  return (
    <Card className="p-4 border-dashed bg-muted/30">
      <div className="flex items-center gap-2 mb-3">
        <Sparkles className="h-4 w-4 text-primary" />
        <p className="text-sm font-medium text-muted-foreground">
          {isBangla ? "আমি যা করতে পারি:" : "Try these AI functions:"}
        </p>
      </div>
      <div className="space-y-2">
        {examples.map((example, index) => (
          <Button
            key={index}
            variant="ghost"
            className="w-full justify-start text-left h-auto py-2 px-3"
            onClick={() => onExampleClick(example.text)}
          >
            <example.icon className={`h-4 w-4 mr-2 flex-shrink-0 ${example.color}`} />
            <span className="text-sm">{example.text}</span>
          </Button>
        ))}
      </div>
    </Card>
  );
};
