import { Shield, Baby, User } from "lucide-react";
import { Badge } from "@/components/ui/badge";
import type { UserRole, SafetyLevel } from "@/hooks/useIdentityEngine";

interface IdentityBadgeProps {
  role: UserRole;
  safetyLevel: SafetyLevel;
  language: string;
}

export const IdentityBadge = ({ role, safetyLevel, language }: IdentityBadgeProps) => {
  const getRoleLabel = () => {
    if (role === 'ava') {
      return language === 'bn' ? 'আভা মোড' : 'Ava Mode';
    }
    return language === 'bn' ? 'Owner মোড' : 'Owner Mode';
  };

  const getSafetyLabel = () => {
    if (safetyLevel === 3) {
      return language === 'bn' ? 'সর্বোচ্চ নিরাপত্তা' : 'Max Safety';
    } else if (safetyLevel === 2) {
      return language === 'bn' ? 'মধ্যম নিরাপত্তা' : 'Medium Safety';
    }
    return language === 'bn' ? 'সাধারণ নিরাপত্তা' : 'Normal Safety';
  };

  const getBadgeVariant = () => {
    if (role === 'ava') return 'secondary';
    return 'default';
  };

  const getIcon = () => {
    if (role === 'ava') return <Baby className="h-3 w-3" />;
    return <User className="h-3 w-3" />;
  };

  return (
    <div className="flex items-center gap-2 flex-wrap">
      <Badge variant={getBadgeVariant()} className="gap-1">
        {getIcon()}
        {getRoleLabel()}
      </Badge>
      <Badge variant="outline" className="gap-1">
        <Shield className="h-3 w-3" />
        {getSafetyLabel()}
      </Badge>
    </div>
  );
};
