import { Alert, AlertDescription } from "@/components/ui/alert";
import { WifiOff, Wifi, Clock } from "lucide-react";
import { Badge } from "@/components/ui/badge";

interface OfflineBannerProps {
  isOnline: boolean;
  queuedCount: number;
  language: string;
}

export const OfflineBanner = ({ isOnline, queuedCount, language }: OfflineBannerProps) => {
  if (isOnline && queuedCount === 0) return null;

  return (
    <Alert variant={isOnline ? "default" : "destructive"} className="mb-4 animate-fade-in">
      <div className="flex items-center gap-2">
        {isOnline ? (
          <Wifi className="h-4 w-4" />
        ) : (
          <WifiOff className="h-4 w-4" />
        )}
        <AlertDescription className="flex items-center gap-2 flex-1">
          {isOnline ? (
            <>
              <span>
                {language === "bn" 
                  ? "অনলাইন - সিঙ্ক হচ্ছে..." 
                  : "Online - Syncing..."}
              </span>
              {queuedCount > 0 && (
                <Badge variant="secondary" className="gap-1">
                  <Clock className="h-3 w-3" />
                  {queuedCount} {language === "bn" ? "বার্তা অপেক্ষমাণ" : "queued"}
                </Badge>
              )}
            </>
          ) : (
            <>
              <span>
                {language === "bn" 
                  ? "অফলাইন মোড - সীমিত বৈশিষ্ট্য উপলব্ধ" 
                  : "Offline Mode - Limited features available"}
              </span>
              {queuedCount > 0 && (
                <Badge variant="outline" className="gap-1">
                  {queuedCount} {language === "bn" ? "সংরক্ষিত" : "saved"}
                </Badge>
              )}
            </>
          )}
        </AlertDescription>
      </div>
    </Alert>
  );
};
