import { Button } from "@/components/ui/button";
import { User, Baby } from "lucide-react";
import type { UserRole } from "@/hooks/useIdentityEngine";

interface RoleSelectorProps {
  role: UserRole;
  onRoleChange: (role: UserRole) => void;
}

export const RoleSelector = ({ role, onRoleChange }: RoleSelectorProps) => {
  return (
    <div className="flex items-center justify-center gap-2 p-2 bg-muted/30 rounded-lg border border-border/50">
      <Button
        variant={role === 'owner' ? 'default' : 'outline'}
        size="sm"
        onClick={() => onRoleChange('owner')}
        className="gap-2"
      >
        <User className="h-4 w-4" />
        Owner
      </Button>
      <Button
        variant={role === 'ava' ? 'default' : 'outline'}
        size="sm"
        onClick={() => onRoleChange('ava')}
        className="gap-2"
      >
        <Baby className="h-4 w-4" />
        Ava
      </Button>
    </div>
  );
};
