export const TypingIndicator = ({ isBangla }: { isBangla: boolean }) => {
  return (
    <div className="flex justify-start animate-fade-in">
      <div className="rounded-2xl px-4 py-3 bg-muted rounded-bl-sm">
        <div className="flex items-center gap-2">
          <div className="flex gap-1">
            <span className="w-2 h-2 bg-muted-foreground/40 rounded-full animate-bounce [animation-delay:-0.3s]" />
            <span className="w-2 h-2 bg-muted-foreground/40 rounded-full animate-bounce [animation-delay:-0.15s]" />
            <span className="w-2 h-2 bg-muted-foreground/40 rounded-full animate-bounce" />
          </div>
          <span className="text-xs text-muted-foreground">
            {isBangla ? "Smart Friend টাইপ করছে..." : "Smart Friend is typing..."}
          </span>
        </div>
      </div>
    </div>
  );
};
