import { Button } from "@/components/ui/button";
import { Mic, MicOff, Volume2, VolumeX } from "lucide-react";
import { Badge } from "@/components/ui/badge";

type VoiceControlsProps = {
  voiceEnabled: boolean;
  isRecording: boolean;
  isSpeaking: boolean;
  recordingTime?: number;
  onToggleVoice: () => void;
  onToggleSpeaking: () => void;
};

export const VoiceControls = ({
  voiceEnabled,
  isRecording,
  isSpeaking,
  recordingTime = 0,
  onToggleVoice,
  onToggleSpeaking,
}: VoiceControlsProps) => {
  const formatTime = (seconds: number) => {
    const mins = Math.floor(seconds / 60);
    const secs = seconds % 60;
    return `${mins}:${secs.toString().padStart(2, "0")}`;
  };

  return (
    <div className="flex items-center gap-2 px-4 py-2 bg-muted/50">
      <Button
        variant={voiceEnabled ? "default" : "outline"}
        size="sm"
        onClick={onToggleVoice}
        className="gap-2"
      >
        {voiceEnabled ? (
          <>
            <Mic className="h-4 w-4" />
            Voice On
          </>
        ) : (
          <>
            <MicOff className="h-4 w-4" />
            Voice Off
          </>
        )}
      </Button>

      {isRecording && (
        <Badge variant="destructive" className="animate-pulse gap-1">
          <div className="h-2 w-2 rounded-full bg-white" />
          Recording {formatTime(recordingTime)}
        </Badge>
      )}

      <Button
        variant={isSpeaking ? "default" : "outline"}
        size="sm"
        onClick={onToggleSpeaking}
        className="gap-2 ml-auto"
      >
        {isSpeaking ? (
          <>
            <Volume2 className="h-4 w-4" />
            Speaking
          </>
        ) : (
          <>
            <VolumeX className="h-4 w-4" />
            Muted
          </>
        )}
      </Button>
    </div>
  );
};
