import { useState, useRef, useEffect } from "react";
import { Mic, Square } from "lucide-react";
import { Button } from "@/components/ui/button";
import { useVoiceToText } from "@/hooks/useVoiceToText";

interface VoiceInputProps {
  onTranscript: (text: string) => void;
}

export const VoiceInput = ({ onTranscript }: VoiceInputProps) => {
  const { isRecording, isProcessing, startRecording } = useVoiceToText();
  const [mediaRecorder, setMediaRecorder] = useState<MediaRecorder | null>(null);

  useEffect(() => {
    const handleVoiceTranscribed = (event: any) => {
      onTranscript(event.detail);
    };

    window.addEventListener("voiceTranscribed", handleVoiceTranscribed);
    return () => window.removeEventListener("voiceTranscribed", handleVoiceTranscribed);
  }, [onTranscript]);

  const handleVoiceInput = async () => {
    if (!isRecording && !mediaRecorder) {
      const recorder = await startRecording();
      setMediaRecorder(recorder);
    } else if (mediaRecorder) {
      mediaRecorder.stop();
      setMediaRecorder(null);
    }
  };

  return (
    <Button
      onClick={handleVoiceInput}
      size="icon"
      variant={isRecording ? "destructive" : "ghost"}
      className="rounded-full"
    >
      {isRecording ? <Square className="h-5 w-5" /> : <Mic className="h-5 w-5" />}
    </Button>
  );
};