import { useLanguage } from "@/hooks/useLanguage";
import offlineTranslations from "@/lib/i18n/offlineTranslations.json";

export const WelcomeMessage = () => {
  const { language } = useLanguage();

  const welcomeText = offlineTranslations.welcome[language as keyof typeof offlineTranslations.welcome] || offlineTranslations.welcome.en;

  return (
    <div className="flex items-center justify-center p-8 animate-fade-in">
      <div className="text-center max-w-md">
        <div className="mb-4 flex justify-center">
          <div className="w-16 h-16 rounded-full bg-primary/10 flex items-center justify-center">
            <span className="text-3xl">🤖</span>
          </div>
        </div>
        <h2 className="text-2xl font-bold text-foreground mb-2">
          {welcomeText}
        </h2>
        <p className="text-muted-foreground text-sm">
          {language === "bn" 
            ? "আমি আপনার সাহায্য করতে প্রস্তুত।" 
            : "I'm ready to help you."}
        </p>
      </div>
    </div>
  );
};
