import { useState } from "react";
import { Copy, Download } from "lucide-react";

interface BuilderCodeEditorProps {
  selectedFile: string | null;
}

const dummyCode = `// Smart Friend Builder - Code Editor
import React from 'react';

function App() {
  return (
    <div className="app">
      <h1>Welcome to Smart Friend Builder</h1>
      <p>Start building your application here.</p>
    </div>
  );
}

export default App;`;

export const BuilderCodeEditor = ({ selectedFile }: BuilderCodeEditorProps) => {
  const [code, setCode] = useState(dummyCode);

  return (
    <div className="h-full flex flex-col bg-background">
      <div className="border-b border-border bg-card p-3 flex items-center justify-between">
        <div className="flex items-center gap-2">
          <span className="text-sm font-medium text-foreground">
            {selectedFile || "App.jsx"}
          </span>
          <span className="px-2 py-0.5 bg-muted text-muted-foreground text-xs rounded">
            JavaScript
          </span>
        </div>
        <div className="flex items-center gap-2">
          <button className="p-2 hover:bg-muted rounded transition-colors">
            <Copy className="h-4 w-4 text-muted-foreground" />
          </button>
          <button className="p-2 hover:bg-muted rounded transition-colors">
            <Download className="h-4 w-4 text-muted-foreground" />
          </button>
        </div>
      </div>

      <div className="flex-1 p-6 overflow-auto">
        <textarea
          value={code}
          onChange={(e) => setCode(e.target.value)}
          className="w-full h-full bg-muted text-foreground font-mono text-sm p-4 rounded-lg border border-border resize-none focus:outline-none focus:ring-2 focus:ring-primary"
          spellCheck={false}
        />
      </div>

      <div className="border-t border-border bg-card p-3 flex items-center justify-between">
        <span className="text-xs text-muted-foreground">
          Line 1, Column 1 • Spaces: 2 • UTF-8
        </span>
        <button className="px-4 py-1.5 bg-primary text-primary-foreground rounded hover:bg-primary/90 transition-colors text-sm">
          Save Changes
        </button>
      </div>
    </div>
  );
};
