import { Monitor, Code2, Upload } from "lucide-react";
import { cn } from "@/lib/utils";
import type { ViewType } from "@/pages/CodeBuilder";

interface BuilderHeaderProps {
  activeView: ViewType;
  onViewChange: (view: ViewType) => void;
}

export const BuilderHeader = ({ activeView, onViewChange }: BuilderHeaderProps) => {
  return (
    <header className="h-14 border-b border-border bg-card flex items-center justify-between px-6">
      <div className="flex items-center gap-4">
        <h1 className="text-lg font-semibold text-foreground">Smart Friend Builder</h1>
        <span className="px-2 py-1 bg-muted text-muted-foreground text-xs rounded-md">
          Development Mode
        </span>
      </div>

      <div className="flex items-center gap-2">
        <button
          onClick={() => onViewChange("preview")}
          className={cn(
            "flex items-center gap-2 px-4 py-2 rounded-lg transition-colors text-sm font-medium",
            activeView === "preview"
              ? "bg-primary text-primary-foreground"
              : "text-muted-foreground hover:bg-muted hover:text-foreground"
          )}
        >
          <Monitor className="h-4 w-4" />
          Preview
        </button>
        <button
          onClick={() => onViewChange("code")}
          className={cn(
            "flex items-center gap-2 px-4 py-2 rounded-lg transition-colors text-sm font-medium",
            activeView === "code"
              ? "bg-primary text-primary-foreground"
              : "text-muted-foreground hover:bg-muted hover:text-foreground"
          )}
        >
          <Code2 className="h-4 w-4" />
          Code
        </button>
        <button
          onClick={() => onViewChange("publish")}
          className="flex items-center gap-2 px-4 py-2 bg-primary text-primary-foreground rounded-lg hover:bg-primary/90 transition-colors text-sm font-medium"
        >
          <Upload className="h-4 w-4" />
          Publish
        </button>
      </div>
    </header>
  );
};
