import { RefreshCw, Maximize2, Smartphone, Tablet, Monitor } from "lucide-react";
import { useState } from "react";
import { cn } from "@/lib/utils";

type DeviceType = "mobile" | "tablet" | "desktop";

export const BuilderPreview = () => {
  const [device, setDevice] = useState<DeviceType>("desktop");

  const getDeviceClass = () => {
    switch (device) {
      case "mobile":
        return "w-[375px]";
      case "tablet":
        return "w-[768px]";
      case "desktop":
        return "w-full";
    }
  };

  return (
    <div className="h-full flex flex-col bg-background">
      <div className="border-b border-border bg-card p-3 flex items-center justify-between">
        <div className="flex items-center gap-2">
          <button
            onClick={() => setDevice("mobile")}
            className={cn(
              "p-2 rounded transition-colors",
              device === "mobile" ? "bg-primary text-primary-foreground" : "hover:bg-muted"
            )}
          >
            <Smartphone className="h-4 w-4" />
          </button>
          <button
            onClick={() => setDevice("tablet")}
            className={cn(
              "p-2 rounded transition-colors",
              device === "tablet" ? "bg-primary text-primary-foreground" : "hover:bg-muted"
            )}
          >
            <Tablet className="h-4 w-4" />
          </button>
          <button
            onClick={() => setDevice("desktop")}
            className={cn(
              "p-2 rounded transition-colors",
              device === "desktop" ? "bg-primary text-primary-foreground" : "hover:bg-muted"
            )}
          >
            <Monitor className="h-4 w-4" />
          </button>
        </div>

        <div className="flex items-center gap-2">
          <button className="p-2 hover:bg-muted rounded transition-colors">
            <RefreshCw className="h-4 w-4 text-muted-foreground" />
          </button>
          <button className="p-2 hover:bg-muted rounded transition-colors">
            <Maximize2 className="h-4 w-4 text-muted-foreground" />
          </button>
        </div>
      </div>

      <div className="flex-1 p-6 overflow-auto flex justify-center items-start">
        <div className={cn("h-full bg-card border border-border rounded-lg transition-all", getDeviceClass())}>
          <div className="h-full flex items-center justify-center p-8">
            <div className="text-center space-y-4">
              <div className="w-16 h-16 bg-primary/10 rounded-full flex items-center justify-center mx-auto">
                <Monitor className="h-8 w-8 text-primary" />
              </div>
              <h3 className="text-xl font-semibold text-foreground">Preview Area</h3>
              <p className="text-muted-foreground">
                Your app preview will appear here
              </p>
              <div className="pt-4">
                <button className="px-6 py-2 bg-primary text-primary-foreground rounded-lg hover:bg-primary/90 transition-colors">
                  Run Preview
                </button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};
