import { Home, MessageSquare, Wand2, FolderTree, Code2, Monitor, Upload, Settings } from "lucide-react";
import { cn } from "@/lib/utils";
import type { ViewType } from "@/pages/CodeBuilder";

interface BuilderSidebarProps {
  activeView: ViewType;
  onViewChange: (view: ViewType) => void;
}

const menuItems = [
  { id: "home" as ViewType, label: "Project Home", icon: Home },
  { id: "chat" as ViewType, label: "Chat", icon: MessageSquare },
  { id: "visual-edits" as ViewType, label: "Visual Edits", icon: Wand2 },
  { id: "files" as ViewType, label: "Files", icon: FolderTree },
  { id: "code" as ViewType, label: "Code", icon: Code2 },
  { id: "preview" as ViewType, label: "Preview", icon: Monitor },
  { id: "publish" as ViewType, label: "Publish", icon: Upload },
  { id: "settings" as ViewType, label: "Settings", icon: Settings },
];

export const BuilderSidebar = ({ activeView, onViewChange }: BuilderSidebarProps) => {
  return (
    <aside className="w-64 bg-card border-r border-border flex flex-col">
      <div className="p-4 border-b border-border">
        <h2 className="text-lg font-semibold text-foreground">Smart Friend Builder</h2>
        <p className="text-xs text-muted-foreground mt-1">Development Mode</p>
      </div>
      
      <nav className="flex-1 p-4 space-y-1">
        {menuItems.map((item) => {
          const Icon = item.icon;
          return (
            <button
              key={item.id}
              onClick={() => onViewChange(item.id)}
              className={cn(
                "w-full flex items-center gap-3 px-4 py-2.5 rounded-lg transition-colors text-left",
                activeView === item.id
                  ? "bg-primary text-primary-foreground"
                  : "text-muted-foreground hover:bg-muted hover:text-foreground"
              )}
            >
              <Icon className="h-5 w-5" />
              <span className="text-sm font-medium">{item.label}</span>
            </button>
          );
        })}
      </nav>

      <div className="p-4 border-t border-border">
        <button className="w-full px-4 py-2 bg-secondary text-secondary-foreground rounded-lg hover:bg-secondary/80 transition-colors text-sm font-medium">
          Download Project ZIP
        </button>
      </div>
    </aside>
  );
};
