import { Link } from 'react-router-dom';
import { Card, CardContent } from '@/components/ui/card';
import { useOnboarding } from '@/hooks/useOnboarding';

const ALL_MODULES = [
  { id: 'academy', name: 'Smart Academy', nameBn: 'স্মার্ট একাডেমি', icon: '📚', route: '/academy' },
  { id: 'design', name: 'Design Hub', nameBn: 'ডিজাইন হাব', icon: '🎨', route: '/smart-design-hub' },
  { id: 'marketer', name: 'Smart Marketer', nameBn: 'স্মার্ট মার্কেটার', icon: '📊', route: '/smart-marketer' },
  { id: 'doctor', name: 'Smart Doctor', nameBn: 'স্মার্ট ডাক্তার', icon: '🏥', route: '/smart-doctor' },
  { id: 'news', name: 'Smart News', nameBn: 'স্মার্ট নিউজ', icon: '📰', route: '/smart-news' },
  { id: 'bazar', name: 'Smart Bazar', nameBn: 'স্মার্ট বাজার', icon: '🛒', route: '/smart-bazar' },
  { id: 'tourist', name: 'Smart Tourist', nameBn: 'স্মার্ট ট্যুরিস্ট', icon: '✈️', route: '/smart-tourist' },
  { id: 'lawyer', name: 'Smart Lawyer', nameBn: 'স্মার্ট আইনজীবী', icon: '⚖️', route: '/smart-lawyer' },
  { id: 'school', name: 'Smart School', nameBn: 'স্মার্ট স্কুল', icon: '🏫', route: '/smart-school' },
  { id: 'call', name: 'Call Center', nameBn: 'কল সেন্টার', icon: '📞', route: '/smart-call-center' },
  { id: 'ad', name: 'AI Ad Firm', nameBn: 'এআই বিজ্ঞাপন', icon: '📺', route: '/smart-ad-firm' },
  { id: 'job', name: 'Smart Job', nameBn: 'স্মার্ট চাকরি', icon: '💼', route: '/smart-job' },
];

interface PinnedModulesProps {
  isBangla: boolean;
}

export const PinnedModules = ({ isBangla }: PinnedModulesProps) => {
  const { onboarding } = useOnboarding();
  const pinnedIds = onboarding.pinnedModules || [];

  const pinnedModules = ALL_MODULES.filter(m => pinnedIds.includes(m.id));

  if (pinnedModules.length === 0) {
    return null;
  }

  return (
    <div className="space-y-3">
      <h2 className="text-lg font-semibold">
        {isBangla ? 'আপনার মডিউল' : 'Your Modules'}
      </h2>
      <div className="grid grid-cols-2 sm:grid-cols-3 gap-3">
        {pinnedModules.map((module) => (
          <Link key={module.id} to={module.route}>
            <Card className="hover:shadow-md transition-shadow cursor-pointer hover:border-primary/50">
              <CardContent className="p-4 text-center">
                <div className="text-4xl mb-2">{module.icon}</div>
                <div className="text-sm font-medium">
                  {isBangla ? module.nameBn : module.name}
                </div>
              </CardContent>
            </Card>
          </Link>
        ))}
      </div>
    </div>
  );
};
