import { useNavigate } from "react-router-dom";
import { Card, CardContent } from "@/components/ui/card";
import { 
  Palette, 
  TrendingUp, 
  GraduationCap, 
  Wand2, 
  PenTool,
  MessageSquare 
} from "lucide-react";

const quickTools = [
  { 
    title: "Start Design", 
    titleBn: "ডিজাইন শুরু করুন",
    icon: Palette, 
    route: "/smart-design-hub",
    gradient: "from-pink-500 to-rose-500"
  },
  { 
    title: "Start Marketing", 
    titleBn: "মার্কেটিং শুরু করুন",
    icon: TrendingUp, 
    route: "/smart-marketer",
    gradient: "from-blue-500 to-cyan-500"
  },
  { 
    title: "Start Exam", 
    titleBn: "পরীক্ষা শুরু করুন",
    icon: GraduationCap, 
    route: "/smart-academy",
    gradient: "from-green-500 to-emerald-500"
  },
  { 
    title: "Fix Image", 
    titleBn: "ছবি ঠিক করুন",
    icon: Wand2, 
    route: "/chat?action=fix-image",
    gradient: "from-purple-500 to-violet-500"
  },
  { 
    title: "Write Content", 
    titleBn: "কন্টেন্ট লিখুন",
    icon: PenTool, 
    route: "/chat?action=write",
    gradient: "from-orange-500 to-amber-500"
  },
  { 
    title: "Smart Chat", 
    titleBn: "স্মার্ট চ্যাট",
    icon: MessageSquare, 
    route: "/chat",
    gradient: "from-indigo-500 to-blue-500"
  },
];

export const QuickTools = () => {
  const navigate = useNavigate();

  return (
    <div className="space-y-4">
      <h2 className="text-lg font-semibold">Quick Tools</h2>
      <div className="grid grid-cols-2 md:grid-cols-3 gap-3">
        {quickTools.map((tool, index) => {
          const Icon = tool.icon;
          return (
            <Card
              key={index}
              className="cursor-pointer hover:shadow-lg transition-all duration-200 hover:scale-105 border-muted"
              onClick={() => navigate(tool.route)}
            >
              <CardContent className="p-4 flex flex-col items-center text-center gap-2">
                <div className={`p-3 rounded-lg bg-gradient-to-br ${tool.gradient}`}>
                  <Icon className="h-6 w-6 text-white" />
                </div>
                <div>
                  <p className="font-medium text-sm">{tool.titleBn}</p>
                  <p className="text-xs text-muted-foreground">{tool.title}</p>
                </div>
              </CardContent>
            </Card>
          );
        })}
      </div>
    </div>
  );
};
