import { useNavigate } from "react-router-dom";
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Sparkles, TrendingUp, Lightbulb } from "lucide-react";
import { Badge } from "@/components/ui/badge";

const recommendations = [
  {
    title: "Build Your First App",
    titleBn: "আপনার প্রথম অ্যাপ তৈরি করুন",
    description: "Use AI Engine to generate code in minutes",
    descriptionBn: "মিনিটের মধ্যে কোড তৈরি করতে AI ইঞ্জিন ব্যবহার করুন",
    route: "/studio/ai-engine",
    badge: "Popular",
    icon: Sparkles,
  },
  {
    title: "Explore Smart Modules",
    titleBn: "স্মার্ট মডিউল দেখুন",
    description: "50+ ready-to-use AI modules",
    descriptionBn: "50+ তৈরি AI মডিউল",
    route: "/seba",
    badge: "New",
    icon: TrendingUp,
  },
  {
    title: "Learn with Smart Academy",
    titleBn: "স্মার্ট একাডেমি দিয়ে শিখুন",
    description: "AI-powered education platform",
    descriptionBn: "AI-চালিত শিক্ষা প্ল্যাটফর্ম",
    route: "/smart-academy",
    badge: "Trending",
    icon: Lightbulb,
  },
];

export const RecommendedForYou = () => {
  const navigate = useNavigate();

  return (
    <div className="space-y-4">
      <h2 className="text-lg font-semibold flex items-center gap-2">
        <Sparkles className="h-5 w-5 text-primary" />
        Recommended for You
      </h2>
      <div className="grid gap-3">
        {recommendations.map((rec, index) => {
          const Icon = rec.icon;
          return (
            <Card key={index} className="hover:shadow-md transition-shadow">
              <CardHeader className="pb-3">
                <div className="flex items-start justify-between">
                  <div className="flex items-center gap-2">
                    <Icon className="h-5 w-5 text-primary" />
                    <CardTitle className="text-base">{rec.titleBn}</CardTitle>
                  </div>
                  <Badge variant="secondary" className="text-xs">
                    {rec.badge}
                  </Badge>
                </div>
                <CardDescription className="text-xs">
                  {rec.descriptionBn}
                </CardDescription>
              </CardHeader>
              <CardContent className="pt-0">
                <Button
                  variant="ghost"
                  size="sm"
                  onClick={() => navigate(rec.route)}
                  className="w-full"
                >
                  Try Now
                </Button>
              </CardContent>
            </Card>
          );
        })}
      </div>
    </div>
  );
};
