import { useState } from "react";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";
import { Terminal, Activity } from "lucide-react";
import { useAIBuilder } from "@/hooks/useAIBuilder";

interface BottomPanelProps {
  projectId: string;
}

export const BottomPanel = ({ projectId }: BottomPanelProps) => {
  const { changes } = useAIBuilder(projectId);
  const [logs] = useState<string[]>([
    "Smart Friend Core Builder initialized",
    "Ready to build...",
  ]);

  return (
    <div className="h-48 border-t border-border bg-card">
      <Tabs defaultValue="terminal" className="h-full flex flex-col">
        <TabsList className="w-full justify-start rounded-none border-b border-border">
          <TabsTrigger value="terminal" className="gap-2">
            <Terminal className="h-4 w-4" />
            Terminal
          </TabsTrigger>
          <TabsTrigger value="ai-logs" className="gap-2">
            <Activity className="h-4 w-4" />
            AI Actions
          </TabsTrigger>
        </TabsList>

        <TabsContent value="terminal" className="flex-1 overflow-auto p-4 font-mono text-sm">
          {logs.map((log, i) => (
            <div key={i} className="text-foreground">
              {log}
            </div>
          ))}
        </TabsContent>

        <TabsContent value="ai-logs" className="flex-1 overflow-auto p-4 text-sm">
          {changes.map((change) => (
            <div key={change.id} className="mb-2 text-foreground">
              <span className="text-muted-foreground">[{new Date(change.created_at).toLocaleTimeString()}]</span>{" "}
              {change.applied ? "✓ Applied" : "○ Generated"}: {change.file_path}
            </div>
          ))}
          {changes.length === 0 && (
            <div className="text-muted-foreground">No AI actions yet</div>
          )}
        </TabsContent>
      </Tabs>
    </div>
  );
};
