import { History, RotateCcw } from "lucide-react";
import { Card } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { ScrollArea } from "@/components/ui/scroll-area";
import { useAIBuilder } from "@/hooks/useAIBuilder";

interface ChangeHistoryProps {
  projectId: string;
  fileId: string | null;
}

export const ChangeHistory = ({ projectId, fileId }: ChangeHistoryProps) => {
  const { changes } = useAIBuilder(projectId);

  const fileChanges = fileId 
    ? changes.filter(c => c.file_path.includes(fileId))
    : changes;

  return (
    <div className="flex flex-col h-full">
      <div className="p-3 border-b border-border bg-card">
        <h3 className="font-semibold text-sm text-foreground flex items-center gap-2">
          <History className="h-4 w-4" />
          Change History
        </h3>
        <p className="text-xs text-muted-foreground mt-1">
          {fileChanges.length} changes
        </p>
      </div>
      <ScrollArea className="flex-1">
        <div className="p-3 space-y-2">
          {fileChanges.length === 0 ? (
            <div className="text-center py-8">
              <History className="h-12 w-12 text-muted-foreground mx-auto mb-3" />
              <p className="text-sm text-muted-foreground">No changes yet</p>
            </div>
          ) : (
            fileChanges.map((change) => (
              <Card key={change.id} className="p-3 bg-muted/50">
                <div className="flex items-start justify-between gap-2">
                  <div className="flex-1 min-w-0">
                    <p className="text-sm font-medium text-foreground truncate">
                      {change.file_path}
                    </p>
                    <p className="text-xs text-muted-foreground mt-1 line-clamp-2">
                      {change.prompt}
                    </p>
                    <p className="text-xs text-muted-foreground mt-1">
                      {new Date(change.created_at).toLocaleString()}
                    </p>
                  </div>
                  <Button size="sm" variant="ghost" className="h-7 shrink-0">
                    <RotateCcw className="h-3 w-3" />
                  </Button>
                </div>
              </Card>
            ))
          )}
        </div>
      </ScrollArea>
    </div>
  );
};
