import { useState, useEffect } from "react";
import { RefreshCw, ExternalLink, Smartphone, Monitor } from "lucide-react";
import { Button } from "@/components/ui/button";
import { Tabs, TabsList, TabsTrigger } from "@/components/ui/tabs";

interface LivePreviewProps {
  projectId: string;
}

export const LivePreview = ({ projectId }: LivePreviewProps) => {
  const [viewMode, setViewMode] = useState<"desktop" | "mobile">("desktop");
  const [refreshKey, setRefreshKey] = useState(0);
  const [previewUrl] = useState(`/preview/${projectId}`);

  const handleRefresh = () => setRefreshKey(prev => prev + 1);

  return (
    <div className="flex flex-col h-full bg-muted/30">
      <div className="flex items-center justify-between p-2 border-b border-border bg-card">
        <h3 className="font-semibold text-sm text-foreground">Live Preview</h3>
        <div className="flex items-center gap-2">
          <Tabs value={viewMode} onValueChange={(v) => setViewMode(v as any)}>
            <TabsList className="h-8">
              <TabsTrigger value="desktop" className="text-xs">
                <Monitor className="h-3 w-3 mr-1" />
                Desktop
              </TabsTrigger>
              <TabsTrigger value="mobile" className="text-xs">
                <Smartphone className="h-3 w-3 mr-1" />
                Mobile
              </TabsTrigger>
            </TabsList>
          </Tabs>
          <Button size="sm" variant="ghost" onClick={handleRefresh}>
            <RefreshCw className="h-4 w-4" />
          </Button>
          <Button size="sm" variant="ghost" asChild>
            <a href={previewUrl} target="_blank" rel="noopener noreferrer">
              <ExternalLink className="h-4 w-4" />
            </a>
          </Button>
        </div>
      </div>
      <div className="flex-1 flex items-center justify-center p-4">
        <iframe
          key={refreshKey}
          src={previewUrl}
          className={`bg-background border border-border rounded-lg shadow-lg transition-all ${
            viewMode === "mobile" ? "w-[375px] h-[667px]" : "w-full h-full"
          }`}
          title="Live Preview"
        />
      </div>
    </div>
  );
};
