import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";
import { FileText, Clock, Lightbulb, Info } from "lucide-react";
import { MemorySettings } from "./MemorySettings";
import { ProjectFile } from "@/hooks/useProjectFiles";
import { AISuggestions } from "./AISuggestions";
import { FileInfo } from "./FileInfo";
import { ChangeHistory } from "./ChangeHistory";

interface RightPanelProps {
  projectId: string;
  selectedFile: ProjectFile | null;
}

export const RightPanel = ({ projectId, selectedFile }: RightPanelProps) => {
  return (
    <div className="h-full flex flex-col">
      <Tabs defaultValue="suggestions" className="flex-1 flex flex-col">
        <TabsList className="w-full justify-start rounded-none border-b border-border">
          <TabsTrigger value="suggestions" className="gap-2">
            <Lightbulb className="h-4 w-4" />
            AI
          </TabsTrigger>
          <TabsTrigger value="info" className="gap-2">
            <Info className="h-4 w-4" />
            Info
          </TabsTrigger>
          <TabsTrigger value="history" className="gap-2">
            <Clock className="h-4 w-4" />
            History
          </TabsTrigger>
          <TabsTrigger value="memory" className="gap-2">
            <FileText className="h-4 w-4" />
            Memory
          </TabsTrigger>
        </TabsList>

        <TabsContent value="suggestions" className="flex-1 overflow-hidden">
          <AISuggestions 
            fileName={selectedFile?.file_name || ""}
            fileContent={selectedFile?.content || ""}
          />
        </TabsContent>

        <TabsContent value="info" className="flex-1 overflow-auto">
          <FileInfo file={selectedFile} />
        </TabsContent>

        <TabsContent value="history" className="flex-1 overflow-hidden">
          <ChangeHistory projectId={projectId} fileId={selectedFile?.id || null} />
        </TabsContent>

        <TabsContent value="memory" className="flex-1 overflow-auto">
          <MemorySettings projectId={projectId} />
        </TabsContent>
      </Tabs>
    </div>
  );
};
