import { FileCode, Save, Play, Download, Eye, EyeOff, Wallet } from "lucide-react";
import { Button } from "@/components/ui/button";
import { useWallet } from "@/hooks/useWallet";

interface TopBarProps {
  projectId: string;
  showPreview: boolean;
  onTogglePreview: () => void;
}

export const TopBar = ({ projectId, showPreview, onTogglePreview }: TopBarProps) => {
  const { wallet } = useWallet();

  return (
    <div className="h-14 border-b border-border bg-card flex items-center justify-between px-4">
      <div className="flex items-center gap-4">
        <div className="flex items-center gap-2">
          <FileCode className="h-5 w-5 text-primary" />
          <span className="font-semibold text-foreground">Smart Friend Core</span>
        </div>

        <div className="h-6 w-px bg-border" />

        <div className="flex items-center gap-2">
          <Button size="sm" variant="ghost" className="gap-2">
            <Save className="h-4 w-4" />
            Save
          </Button>
          <Button size="sm" variant="ghost" className="gap-2">
            <Play className="h-4 w-4" />
            Run
          </Button>
          <Button size="sm" variant="ghost" className="gap-2" onClick={onTogglePreview}>
            {showPreview ? <EyeOff className="h-4 w-4" /> : <Eye className="h-4 w-4" />}
            {showPreview ? "Hide" : "Show"} Preview
          </Button>
          <Button size="sm" variant="ghost" className="gap-2">
            <Download className="h-4 w-4" />
            Download
          </Button>
        </div>
      </div>

      <div className="flex items-center gap-4">
        <div className="flex items-center gap-2 px-3 py-1.5 rounded-lg bg-muted">
          <Wallet className="h-4 w-4 text-primary" />
          <span className="text-sm font-medium text-foreground">
            ৳{wallet?.balance.toFixed(2) || "0.00"}
          </span>
        </div>
      </div>
    </div>
  );
};
