import { Button } from "@/components/ui/button";
import { Badge } from "@/components/ui/badge";
import { ScrollArea, ScrollBar } from "@/components/ui/scroll-area";

export type ModuleCategory = "all" | "core" | "education" | "business" | "health" | "future";

type ModuleFiltersProps = {
  activeCategory: ModuleCategory;
  onCategoryChange: (category: ModuleCategory) => void;
};

const categories = [
  { value: "all", label: "All", labelBn: "সব", count: 50 },
  { value: "core", label: "Core", labelBn: "মূল", count: 12 },
  { value: "education", label: "Education", labelBn: "শিক্ষা", count: 15 },
  { value: "business", label: "Business", labelBn: "ব্যবসা", count: 10 },
  { value: "health", label: "Health", labelBn: "স্বাস্থ্য", count: 8 },
  { value: "future", label: "Future", labelBn: "ভবিষ্যৎ", count: 5 },
];

export const ModuleFilters = ({ activeCategory, onCategoryChange }: ModuleFiltersProps) => {
  return (
    <ScrollArea className="w-full whitespace-nowrap">
      <div className="flex gap-2 pb-2">
        {categories.map((cat) => (
          <Button
            key={cat.value}
            variant={activeCategory === cat.value ? "default" : "outline"}
            size="sm"
            onClick={() => onCategoryChange(cat.value as ModuleCategory)}
            className="gap-2 shrink-0"
          >
            {cat.labelBn}
            <Badge variant="secondary" className="ml-1 text-xs">
              {cat.count}
            </Badge>
          </Button>
        ))}
      </div>
      <ScrollBar orientation="horizontal" />
    </ScrollArea>
  );
};
