export const SebaFooter = () => {
  const currentYear = new Date().getFullYear();

  return (
    <footer className="border-t border-border/50 bg-card">
      <div className="container mx-auto px-4 py-12">
        <div className="grid grid-cols-1 md:grid-cols-4 gap-8 mb-8">
          {/* Brand */}
          <div className="space-y-4">
            <h3 className="text-xl font-bold bg-gradient-to-r from-primary to-accent bg-clip-text text-transparent">
              Smart Seba
            </h3>
            <p className="text-sm text-muted-foreground">
              AI-powered ecosystem with 50+ smart modules for modern life and business.
            </p>
          </div>

          {/* Quick Links */}
          <div className="space-y-3">
            <h4 className="font-semibold text-foreground">Quick Links</h4>
            <ul className="space-y-2 text-sm">
              <li>
                <a href="/seba" className="text-muted-foreground hover:text-primary transition-colors">
                  Home
                </a>
              </li>
              <li>
                <a href="#modules-section" className="text-muted-foreground hover:text-primary transition-colors">
                  Modules
                </a>
              </li>
              <li>
                <a href="/auth" className="text-muted-foreground hover:text-primary transition-colors">
                  Login
                </a>
              </li>
            </ul>
          </div>

          {/* Modules */}
          <div className="space-y-3">
            <h4 className="font-semibold text-foreground">Popular Modules</h4>
            <ul className="space-y-2 text-sm">
              <li>
                <a href="/module/smart-friend" className="text-muted-foreground hover:text-primary transition-colors">
                  Smart Friend AI
                </a>
              </li>
              <li>
                <a href="/module/smart-academy" className="text-muted-foreground hover:text-primary transition-colors">
                  Smart Academy
                </a>
              </li>
              <li>
                <a href="/module/smart-hospital" className="text-muted-foreground hover:text-primary transition-colors">
                  Smart Hospital
                </a>
              </li>
              <li>
                <a href="/module/smart-pay" className="text-muted-foreground hover:text-primary transition-colors">
                  Smart Pay
                </a>
              </li>
            </ul>
          </div>

          {/* Contact */}
          <div className="space-y-3">
            <h4 className="font-semibold text-foreground">Connect</h4>
            <div className="space-y-2 text-sm text-muted-foreground">
              <p>Building the future of AI-powered services</p>
              <p className="text-xs">For partnerships and inquiries</p>
            </div>
          </div>
        </div>

        {/* Bottom Bar */}
        <div className="border-t border-border/50 pt-8 mt-8">
          <div className="flex flex-col md:flex-row items-center justify-between gap-4 text-center md:text-left">
            <div className="space-y-1">
              <p className="text-sm text-muted-foreground">
                © {currentYear} Smart Seba HQ. All rights reserved.
              </p>
            </div>

            <div className="flex flex-col items-center md:items-end gap-1">
              <p className="text-sm">
                <span className="text-muted-foreground">Powered by </span>
                <span className="font-bold text-primary">Smart Friend AI</span>
              </p>
              <p className="text-xs text-muted-foreground">
                Developed By: <span className="font-semibold text-foreground">Engineer S M Nazrul Islam Tasnim</span>
              </p>
            </div>
          </div>
        </div>
      </div>
    </footer>
  );
};
