import { Button } from "@/components/ui/button";
import { SmartFriendIcon } from "@/components/SmartFriendIcon";
import { useNavigate } from "react-router-dom";
import { useLanguage } from "@/hooks/useLanguage";

export const SebaHero = () => {
  const navigate = useNavigate();
  const { t } = useLanguage();

  return (
    <section className="relative overflow-hidden bg-gradient-to-b from-background via-background to-secondary/10">
      <div className="container mx-auto px-4 py-16 md:py-24 lg:py-32">
        <div className="grid lg:grid-cols-2 gap-12 items-center">
          {/* Left Side - Content */}
          <div className="space-y-8 text-center lg:text-left">
            {/* Logo placeholder - can be replaced with actual logo */}
            <div className="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-primary/10 border border-primary/20">
              <div className="w-2 h-2 rounded-full bg-primary animate-pulse" />
              <span className="text-sm font-semibold text-primary">Smart Seba Platform</span>
            </div>

            {/* Main Headline */}
            <h1 className="text-4xl sm:text-5xl md:text-6xl lg:text-7xl font-bold leading-tight">
              <span className="bg-gradient-to-r from-primary via-accent to-primary bg-clip-text text-transparent">
                Smart Seba
              </span>
              <br />
              <span className="text-foreground">
                One Super Platform for
              </span>
              <br />
              <span className="text-primary">50+ Smart Services</span>
            </h1>

            {/* Subtitle */}
            <p className="text-lg md:text-xl text-muted-foreground max-w-2xl mx-auto lg:mx-0 leading-relaxed">
              AI-powered ecosystem with Smart Friend, Smart Academy, Smart Hospital, 
              Smart Pay, Smart Bazar, Smart Lawyer and 50+ smart modules in one place.
            </p>

            {/* CTA Buttons */}
            <div className="flex flex-col sm:flex-row gap-4 justify-center lg:justify-start">
              <Button 
                size="lg" 
                className="text-base px-8 py-6 rounded-xl shadow-lg hover:shadow-xl transition-all"
                onClick={() => {
                  const modulesSection = document.getElementById('modules-section');
                  modulesSection?.scrollIntoView({ behavior: 'smooth' });
                }}
              >
                Explore Modules
              </Button>
              <Button 
                size="lg" 
                variant="outline"
                className="text-base px-8 py-6 rounded-xl border-2 hover:bg-accent/10"
                onClick={() => navigate('/auth')}
              >
                Login to Smart Seba
              </Button>
            </div>

            {/* Stats */}
            <div className="flex flex-wrap gap-8 justify-center lg:justify-start pt-8">
              <div className="text-center lg:text-left">
                <div className="text-3xl font-bold text-primary">50+</div>
                <div className="text-sm text-muted-foreground">Smart Modules</div>
              </div>
              <div className="text-center lg:text-left">
                <div className="text-3xl font-bold text-primary">AI-Powered</div>
                <div className="text-sm text-muted-foreground">Intelligence</div>
              </div>
              <div className="text-center lg:text-left">
                <div className="text-3xl font-bold text-primary">24/7</div>
                <div className="text-sm text-muted-foreground">Available</div>
              </div>
            </div>
          </div>

          {/* Right Side - Visual */}
          <div className="relative flex items-center justify-center">
            <div className="relative">
              {/* Animated background glow */}
              <div className="absolute inset-0 bg-gradient-to-br from-primary/20 via-accent/20 to-primary/20 rounded-full blur-3xl animate-pulse" />
              
              {/* Main icon container */}
              <div className="relative transform hover:scale-105 transition-transform duration-300">
                <SmartFriendIcon />
              </div>

              {/* Floating elements */}
              <div className="absolute -top-4 -right-4 w-20 h-20 bg-gradient-to-br from-primary to-accent rounded-2xl opacity-20 animate-float" />
              <div className="absolute -bottom-4 -left-4 w-16 h-16 bg-gradient-to-br from-accent to-primary rounded-2xl opacity-20 animate-float" style={{ animationDelay: '1s' }} />
            </div>
          </div>
        </div>
      </div>

      {/* Bottom wave decoration */}
      <div className="absolute bottom-0 left-0 right-0 h-16 bg-gradient-to-t from-secondary/20 to-transparent" />
    </section>
  );
};
