import { useQuery } from "@tanstack/react-query";
import { supabase } from "@/integrations/supabase/client";

export const useOwnerCheck = () => {
  const { data: isOwner, isLoading } = useQuery({
    queryKey: ["owner_check"],
    queryFn: async () => {
      const { data: { user } } = await supabase.auth.getUser();
      if (!user) return false;

      // Check if user has 'owner' role in user_roles table
      const { data } = await supabase
        .from("user_roles")
        .select("role")
        .eq("user_id", user.id)
        .eq("role", "owner")
        .maybeSingle();

      return !!data;
    },
  });

  const { data: hasAdminRole } = useQuery({
    queryKey: ["admin_role"],
    queryFn: async () => {
      const { data: { user } } = await supabase.auth.getUser();
      if (!user) return false;

      const { data, error } = await supabase
        .from("user_roles")
        .select("role")
        .eq("user_id", user.id)
        .eq("role", "admin")
        .maybeSingle();

      if (error) return false;
      return !!data;
    },
  });

  return {
    isOwner: isOwner || false,
    isAdmin: hasAdminRole || false,
    isLoading,
  };
};