export type Json =
  | string
  | number
  | boolean
  | null
  | { [key: string]: Json | undefined }
  | Json[]

export type Database = {
  // Allows to automatically instantiate createClient with right options
  // instead of createClient<Database, { PostgrestVersion: 'XX' }>(URL, KEY)
  __InternalSupabase: {
    PostgrestVersion: "13.0.5"
  }
  public: {
    Tables: {
      academy_chapters: {
        Row: {
          content: string | null
          created_at: string | null
          id: string
          order_index: number | null
          subject_id: string | null
          title: string
          video_url: string | null
        }
        Insert: {
          content?: string | null
          created_at?: string | null
          id?: string
          order_index?: number | null
          subject_id?: string | null
          title: string
          video_url?: string | null
        }
        Update: {
          content?: string | null
          created_at?: string | null
          id?: string
          order_index?: number | null
          subject_id?: string | null
          title?: string
          video_url?: string | null
        }
        Relationships: [
          {
            foreignKeyName: "academy_chapters_subject_id_fkey"
            columns: ["subject_id"]
            isOneToOne: false
            referencedRelation: "academy_subjects"
            referencedColumns: ["id"]
          },
        ]
      }
      academy_classes: {
        Row: {
          created_at: string | null
          description: string | null
          grade_level: string | null
          id: string
          title: string
        }
        Insert: {
          created_at?: string | null
          description?: string | null
          grade_level?: string | null
          id?: string
          title: string
        }
        Update: {
          created_at?: string | null
          description?: string | null
          grade_level?: string | null
          id?: string
          title?: string
        }
        Relationships: []
      }
      academy_exams: {
        Row: {
          created_at: string | null
          duration_minutes: number | null
          exam_type: string | null
          id: string
          questions: Json | null
          subject_id: string | null
          title: string
        }
        Insert: {
          created_at?: string | null
          duration_minutes?: number | null
          exam_type?: string | null
          id?: string
          questions?: Json | null
          subject_id?: string | null
          title: string
        }
        Update: {
          created_at?: string | null
          duration_minutes?: number | null
          exam_type?: string | null
          id?: string
          questions?: Json | null
          subject_id?: string | null
          title?: string
        }
        Relationships: [
          {
            foreignKeyName: "academy_exams_subject_id_fkey"
            columns: ["subject_id"]
            isOneToOne: false
            referencedRelation: "academy_subjects"
            referencedColumns: ["id"]
          },
        ]
      }
      academy_student_results: {
        Row: {
          ai_evaluation: string | null
          answers: Json | null
          exam_id: string | null
          id: string
          score: number | null
          submitted_at: string | null
          user_id: string
        }
        Insert: {
          ai_evaluation?: string | null
          answers?: Json | null
          exam_id?: string | null
          id?: string
          score?: number | null
          submitted_at?: string | null
          user_id: string
        }
        Update: {
          ai_evaluation?: string | null
          answers?: Json | null
          exam_id?: string | null
          id?: string
          score?: number | null
          submitted_at?: string | null
          user_id?: string
        }
        Relationships: [
          {
            foreignKeyName: "academy_student_results_exam_id_fkey"
            columns: ["exam_id"]
            isOneToOne: false
            referencedRelation: "academy_exams"
            referencedColumns: ["id"]
          },
        ]
      }
      academy_subjects: {
        Row: {
          class_id: string | null
          created_at: string | null
          description: string | null
          id: string
          title: string
        }
        Insert: {
          class_id?: string | null
          created_at?: string | null
          description?: string | null
          id?: string
          title: string
        }
        Update: {
          class_id?: string | null
          created_at?: string | null
          description?: string | null
          id?: string
          title?: string
        }
        Relationships: [
          {
            foreignKeyName: "academy_subjects_class_id_fkey"
            columns: ["class_id"]
            isOneToOne: false
            referencedRelation: "academy_classes"
            referencedColumns: ["id"]
          },
        ]
      }
      ad_campaigns: {
        Row: {
          created_at: string | null
          id: string
          script: string | null
          status: string | null
          storyboard: Json | null
          title: string
          user_id: string
          video_concept: string | null
          voiceover_url: string | null
        }
        Insert: {
          created_at?: string | null
          id?: string
          script?: string | null
          status?: string | null
          storyboard?: Json | null
          title: string
          user_id: string
          video_concept?: string | null
          voiceover_url?: string | null
        }
        Update: {
          created_at?: string | null
          id?: string
          script?: string | null
          status?: string | null
          storyboard?: Json | null
          title?: string
          user_id?: string
          video_concept?: string | null
          voiceover_url?: string | null
        }
        Relationships: []
      }
      affiliate_conversions: {
        Row: {
          affiliate_link_id: string | null
          commission_amount: number | null
          created_at: string | null
          id: string
          module_slug: string | null
          referred_user_id: string | null
          status: string | null
        }
        Insert: {
          affiliate_link_id?: string | null
          commission_amount?: number | null
          created_at?: string | null
          id?: string
          module_slug?: string | null
          referred_user_id?: string | null
          status?: string | null
        }
        Update: {
          affiliate_link_id?: string | null
          commission_amount?: number | null
          created_at?: string | null
          id?: string
          module_slug?: string | null
          referred_user_id?: string | null
          status?: string | null
        }
        Relationships: [
          {
            foreignKeyName: "affiliate_conversions_affiliate_link_id_fkey"
            columns: ["affiliate_link_id"]
            isOneToOne: false
            referencedRelation: "affiliate_links"
            referencedColumns: ["id"]
          },
        ]
      }
      affiliate_links: {
        Row: {
          clicks: number | null
          conversions: number | null
          created_at: string | null
          id: string
          module_slug: string | null
          referral_code: string
          total_earnings: number | null
          updated_at: string | null
          user_id: string
        }
        Insert: {
          clicks?: number | null
          conversions?: number | null
          created_at?: string | null
          id?: string
          module_slug?: string | null
          referral_code: string
          total_earnings?: number | null
          updated_at?: string | null
          user_id: string
        }
        Update: {
          clicks?: number | null
          conversions?: number | null
          created_at?: string | null
          id?: string
          module_slug?: string | null
          referral_code?: string
          total_earnings?: number | null
          updated_at?: string | null
          user_id?: string
        }
        Relationships: []
      }
      affiliate_payouts: {
        Row: {
          amount: number
          created_at: string | null
          id: string
          payment_details: Json | null
          payment_method: string | null
          processed_at: string | null
          status: string | null
          user_id: string
        }
        Insert: {
          amount: number
          created_at?: string | null
          id?: string
          payment_details?: Json | null
          payment_method?: string | null
          processed_at?: string | null
          status?: string | null
          user_id: string
        }
        Update: {
          amount?: number
          created_at?: string | null
          id?: string
          payment_details?: Json | null
          payment_method?: string | null
          processed_at?: string | null
          status?: string | null
          user_id?: string
        }
        Relationships: []
      }
      affiliate_settings: {
        Row: {
          commission_rate: number | null
          created_at: string | null
          enabled: boolean | null
          id: string
          min_payout: number | null
          module_slug: string
          updated_at: string | null
        }
        Insert: {
          commission_rate?: number | null
          created_at?: string | null
          enabled?: boolean | null
          id?: string
          min_payout?: number | null
          module_slug: string
          updated_at?: string | null
        }
        Update: {
          commission_rate?: number | null
          created_at?: string | null
          enabled?: boolean | null
          id?: string
          min_payout?: number | null
          module_slug?: string
          updated_at?: string | null
        }
        Relationships: []
      }
      ai_changes: {
        Row: {
          applied: boolean | null
          created_at: string | null
          file_path: string
          generated_code: string
          id: string
          original_code: string | null
          project_id: string
          prompt: string
          user_id: string
        }
        Insert: {
          applied?: boolean | null
          created_at?: string | null
          file_path: string
          generated_code: string
          id?: string
          original_code?: string | null
          project_id: string
          prompt: string
          user_id: string
        }
        Update: {
          applied?: boolean | null
          created_at?: string | null
          file_path?: string
          generated_code?: string
          id?: string
          original_code?: string | null
          project_id?: string
          prompt?: string
          user_id?: string
        }
        Relationships: []
      }
      appointments: {
        Row: {
          appointment_date: string
          created_at: string | null
          doctor_id: string | null
          id: string
          patient_id: string
          prescription: string | null
          status: string | null
          symptoms: string | null
        }
        Insert: {
          appointment_date: string
          created_at?: string | null
          doctor_id?: string | null
          id?: string
          patient_id: string
          prescription?: string | null
          status?: string | null
          symptoms?: string | null
        }
        Update: {
          appointment_date?: string
          created_at?: string | null
          doctor_id?: string | null
          id?: string
          patient_id?: string
          prescription?: string | null
          status?: string | null
          symptoms?: string | null
        }
        Relationships: [
          {
            foreignKeyName: "appointments_doctor_id_fkey"
            columns: ["doctor_id"]
            isOneToOne: false
            referencedRelation: "doctors"
            referencedColumns: ["id"]
          },
        ]
      }
      bazar_merchants: {
        Row: {
          business_logo: string | null
          business_name: string
          commission_rate: number | null
          created_at: string | null
          custom_domain: string | null
          id: string
          is_active: boolean | null
          user_id: string
        }
        Insert: {
          business_logo?: string | null
          business_name: string
          commission_rate?: number | null
          created_at?: string | null
          custom_domain?: string | null
          id?: string
          is_active?: boolean | null
          user_id: string
        }
        Update: {
          business_logo?: string | null
          business_name?: string
          commission_rate?: number | null
          created_at?: string | null
          custom_domain?: string | null
          id?: string
          is_active?: boolean | null
          user_id?: string
        }
        Relationships: []
      }
      bazar_orders: {
        Row: {
          commission_amount: number | null
          created_at: string | null
          customer_id: string
          delivery_address: string | null
          id: string
          merchant_id: string | null
          products: Json | null
          status: string | null
          total_amount: number
        }
        Insert: {
          commission_amount?: number | null
          created_at?: string | null
          customer_id: string
          delivery_address?: string | null
          id?: string
          merchant_id?: string | null
          products?: Json | null
          status?: string | null
          total_amount: number
        }
        Update: {
          commission_amount?: number | null
          created_at?: string | null
          customer_id?: string
          delivery_address?: string | null
          id?: string
          merchant_id?: string | null
          products?: Json | null
          status?: string | null
          total_amount?: number
        }
        Relationships: [
          {
            foreignKeyName: "bazar_orders_merchant_id_fkey"
            columns: ["merchant_id"]
            isOneToOne: false
            referencedRelation: "bazar_merchants"
            referencedColumns: ["id"]
          },
        ]
      }
      bazar_products: {
        Row: {
          category: string | null
          created_at: string | null
          description: string | null
          id: string
          images: string[] | null
          is_active: boolean | null
          merchant_id: string | null
          price: number
          stock: number | null
          title: string
        }
        Insert: {
          category?: string | null
          created_at?: string | null
          description?: string | null
          id?: string
          images?: string[] | null
          is_active?: boolean | null
          merchant_id?: string | null
          price: number
          stock?: number | null
          title: string
        }
        Update: {
          category?: string | null
          created_at?: string | null
          description?: string | null
          id?: string
          images?: string[] | null
          is_active?: boolean | null
          merchant_id?: string | null
          price?: number
          stock?: number | null
          title?: string
        }
        Relationships: [
          {
            foreignKeyName: "bazar_products_merchant_id_fkey"
            columns: ["merchant_id"]
            isOneToOne: false
            referencedRelation: "bazar_merchants"
            referencedColumns: ["id"]
          },
        ]
      }
      call_history: {
        Row: {
          ai_summary: string | null
          call_duration: number | null
          created_at: string | null
          id: string
          transcript: string | null
          user_id: string | null
        }
        Insert: {
          ai_summary?: string | null
          call_duration?: number | null
          created_at?: string | null
          id?: string
          transcript?: string | null
          user_id?: string | null
        }
        Update: {
          ai_summary?: string | null
          call_duration?: number | null
          created_at?: string | null
          id?: string
          transcript?: string | null
          user_id?: string | null
        }
        Relationships: []
      }
      call_tickets: {
        Row: {
          ai_response: string | null
          caller_id: string | null
          created_at: string | null
          description: string | null
          id: string
          priority: string | null
          resolved_at: string | null
          status: string | null
          subject: string
        }
        Insert: {
          ai_response?: string | null
          caller_id?: string | null
          created_at?: string | null
          description?: string | null
          id?: string
          priority?: string | null
          resolved_at?: string | null
          status?: string | null
          subject: string
        }
        Update: {
          ai_response?: string | null
          caller_id?: string | null
          created_at?: string | null
          description?: string | null
          id?: string
          priority?: string | null
          resolved_at?: string | null
          status?: string | null
          subject?: string
        }
        Relationships: []
      }
      calls: {
        Row: {
          call_type: string
          callee_id: string
          caller_id: string
          created_at: string | null
          ended_at: string | null
          id: string
          started_at: string | null
          status: string
        }
        Insert: {
          call_type: string
          callee_id: string
          caller_id: string
          created_at?: string | null
          ended_at?: string | null
          id?: string
          started_at?: string | null
          status?: string
        }
        Update: {
          call_type?: string
          callee_id?: string
          caller_id?: string
          created_at?: string | null
          ended_at?: string | null
          id?: string
          started_at?: string | null
          status?: string
        }
        Relationships: []
      }
      code_modules: {
        Row: {
          category: string
          created_at: string | null
          created_by: string
          description: string | null
          id: string
          module_config: Json | null
          name: string
          slug: string
          updated_at: string | null
        }
        Insert: {
          category?: string
          created_at?: string | null
          created_by: string
          description?: string | null
          id?: string
          module_config?: Json | null
          name: string
          slug: string
          updated_at?: string | null
        }
        Update: {
          category?: string
          created_at?: string | null
          created_by?: string
          description?: string | null
          id?: string
          module_config?: Json | null
          name?: string
          slug?: string
          updated_at?: string | null
        }
        Relationships: []
      }
      code_patches: {
        Row: {
          applied_at: string | null
          created_at: string
          created_by: string
          file_path: string
          fix_plan_id: string | null
          id: string
          original_code: string | null
          patched_code: string
          status: string
        }
        Insert: {
          applied_at?: string | null
          created_at?: string
          created_by: string
          file_path: string
          fix_plan_id?: string | null
          id?: string
          original_code?: string | null
          patched_code: string
          status?: string
        }
        Update: {
          applied_at?: string | null
          created_at?: string
          created_by?: string
          file_path?: string
          fix_plan_id?: string | null
          id?: string
          original_code?: string | null
          patched_code?: string
          status?: string
        }
        Relationships: [
          {
            foreignKeyName: "code_patches_fix_plan_id_fkey"
            columns: ["fix_plan_id"]
            isOneToOne: false
            referencedRelation: "fix_plans"
            referencedColumns: ["id"]
          },
        ]
      }
      core_brain_logs: {
        Row: {
          created_at: string
          details: Json | null
          id: string
          message: string
          type: string
          user_id: string | null
        }
        Insert: {
          created_at?: string
          details?: Json | null
          id?: string
          message: string
          type: string
          user_id?: string | null
        }
        Update: {
          created_at?: string
          details?: Json | null
          id?: string
          message?: string
          type?: string
          user_id?: string | null
        }
        Relationships: []
      }
      core_brain_plans: {
        Row: {
          created_at: string
          created_by: string
          description: string
          id: string
          status: string
          title: string
          updated_at: string
        }
        Insert: {
          created_at?: string
          created_by: string
          description: string
          id?: string
          status?: string
          title: string
          updated_at?: string
        }
        Update: {
          created_at?: string
          created_by?: string
          description?: string
          id?: string
          status?: string
          title?: string
          updated_at?: string
        }
        Relationships: []
      }
      critical_error_notifications: {
        Row: {
          created_at: string | null
          details: Json | null
          error_id: string | null
          id: string
          notification_type: string
          notified_at: string | null
        }
        Insert: {
          created_at?: string | null
          details?: Json | null
          error_id?: string | null
          id?: string
          notification_type?: string
          notified_at?: string | null
        }
        Update: {
          created_at?: string | null
          details?: Json | null
          error_id?: string | null
          id?: string
          notification_type?: string
          notified_at?: string | null
        }
        Relationships: [
          {
            foreignKeyName: "critical_error_notifications_error_id_fkey"
            columns: ["error_id"]
            isOneToOne: false
            referencedRelation: "scan_results"
            referencedColumns: ["id"]
          },
        ]
      }
      design_projects: {
        Row: {
          category: string | null
          created_at: string | null
          design_data: Json | null
          export_format: string | null
          id: string
          template_id: string | null
          title: string
          updated_at: string | null
          user_id: string
        }
        Insert: {
          category?: string | null
          created_at?: string | null
          design_data?: Json | null
          export_format?: string | null
          id?: string
          template_id?: string | null
          title: string
          updated_at?: string | null
          user_id: string
        }
        Update: {
          category?: string | null
          created_at?: string | null
          design_data?: Json | null
          export_format?: string | null
          id?: string
          template_id?: string | null
          title?: string
          updated_at?: string | null
          user_id?: string
        }
        Relationships: []
      }
      design_templates: {
        Row: {
          category: string
          created_at: string | null
          id: string
          is_premium: boolean | null
          template_data: Json | null
          thumbnail_url: string | null
          title: string
        }
        Insert: {
          category: string
          created_at?: string | null
          id?: string
          is_premium?: boolean | null
          template_data?: Json | null
          thumbnail_url?: string | null
          title: string
        }
        Update: {
          category?: string
          created_at?: string | null
          id?: string
          is_premium?: boolean | null
          template_data?: Json | null
          thumbnail_url?: string | null
          title?: string
        }
        Relationships: []
      }
      dev_brain_logs: {
        Row: {
          action_type: string
          applied_at: string | null
          created_at: string
          description: string
          diff_content: string | null
          file_path: string | null
          id: string
          metadata: Json | null
          status: string
          user_id: string
        }
        Insert: {
          action_type: string
          applied_at?: string | null
          created_at?: string
          description: string
          diff_content?: string | null
          file_path?: string | null
          id?: string
          metadata?: Json | null
          status?: string
          user_id: string
        }
        Update: {
          action_type?: string
          applied_at?: string | null
          created_at?: string
          description?: string
          diff_content?: string | null
          file_path?: string | null
          id?: string
          metadata?: Json | null
          status?: string
          user_id?: string
        }
        Relationships: []
      }
      doctors: {
        Row: {
          available_days: string[] | null
          avatar_url: string | null
          consultation_fee: number | null
          created_at: string | null
          department_id: string | null
          experience_years: number | null
          id: string
          name: string
          qualifications: string | null
          specialty: string | null
          user_id: string | null
        }
        Insert: {
          available_days?: string[] | null
          avatar_url?: string | null
          consultation_fee?: number | null
          created_at?: string | null
          department_id?: string | null
          experience_years?: number | null
          id?: string
          name: string
          qualifications?: string | null
          specialty?: string | null
          user_id?: string | null
        }
        Update: {
          available_days?: string[] | null
          avatar_url?: string | null
          consultation_fee?: number | null
          created_at?: string | null
          department_id?: string | null
          experience_years?: number | null
          id?: string
          name?: string
          qualifications?: string | null
          specialty?: string | null
          user_id?: string | null
        }
        Relationships: [
          {
            foreignKeyName: "doctors_department_id_fkey"
            columns: ["department_id"]
            isOneToOne: false
            referencedRelation: "hospital_departments"
            referencedColumns: ["id"]
          },
        ]
      }
      erp_attendance: {
        Row: {
          created_at: string | null
          date: string
          id: string
          status: string | null
          student_id: string | null
        }
        Insert: {
          created_at?: string | null
          date: string
          id?: string
          status?: string | null
          student_id?: string | null
        }
        Update: {
          created_at?: string | null
          date?: string
          id?: string
          status?: string | null
          student_id?: string | null
        }
        Relationships: [
          {
            foreignKeyName: "erp_attendance_student_id_fkey"
            columns: ["student_id"]
            isOneToOne: false
            referencedRelation: "erp_students"
            referencedColumns: ["id"]
          },
        ]
      }
      erp_homework: {
        Row: {
          created_at: string | null
          description: string | null
          due_date: string | null
          id: string
          status: string | null
          student_id: string | null
          subject: string
          title: string
        }
        Insert: {
          created_at?: string | null
          description?: string | null
          due_date?: string | null
          id?: string
          status?: string | null
          student_id?: string | null
          subject: string
          title: string
        }
        Update: {
          created_at?: string | null
          description?: string | null
          due_date?: string | null
          id?: string
          status?: string | null
          student_id?: string | null
          subject?: string
          title?: string
        }
        Relationships: [
          {
            foreignKeyName: "erp_homework_student_id_fkey"
            columns: ["student_id"]
            isOneToOne: false
            referencedRelation: "erp_students"
            referencedColumns: ["id"]
          },
        ]
      }
      erp_schools: {
        Row: {
          address: string | null
          contact: string | null
          created_at: string | null
          id: string
          logo_url: string | null
          name: string
        }
        Insert: {
          address?: string | null
          contact?: string | null
          created_at?: string | null
          id?: string
          logo_url?: string | null
          name: string
        }
        Update: {
          address?: string | null
          contact?: string | null
          created_at?: string | null
          id?: string
          logo_url?: string | null
          name?: string
        }
        Relationships: []
      }
      erp_students: {
        Row: {
          class_name: string | null
          created_at: string | null
          id: string
          roll_number: string | null
          school_id: string | null
          section: string | null
          student_id: string
          user_id: string | null
        }
        Insert: {
          class_name?: string | null
          created_at?: string | null
          id?: string
          roll_number?: string | null
          school_id?: string | null
          section?: string | null
          student_id: string
          user_id?: string | null
        }
        Update: {
          class_name?: string | null
          created_at?: string | null
          id?: string
          roll_number?: string | null
          school_id?: string | null
          section?: string | null
          student_id?: string
          user_id?: string | null
        }
        Relationships: [
          {
            foreignKeyName: "erp_students_school_id_fkey"
            columns: ["school_id"]
            isOneToOne: false
            referencedRelation: "erp_schools"
            referencedColumns: ["id"]
          },
        ]
      }
      fix_plans: {
        Row: {
          ai_suggestion: string | null
          created_at: string
          created_by: string
          description: string
          id: string
          priority: string
          scan_result_id: string | null
          status: string
          title: string
          updated_at: string
        }
        Insert: {
          ai_suggestion?: string | null
          created_at?: string
          created_by: string
          description: string
          id?: string
          priority?: string
          scan_result_id?: string | null
          status?: string
          title: string
          updated_at?: string
        }
        Update: {
          ai_suggestion?: string | null
          created_at?: string
          created_by?: string
          description?: string
          id?: string
          priority?: string
          scan_result_id?: string | null
          status?: string
          title?: string
          updated_at?: string
        }
        Relationships: [
          {
            foreignKeyName: "fix_plans_scan_result_id_fkey"
            columns: ["scan_result_id"]
            isOneToOne: false
            referencedRelation: "scan_results"
            referencedColumns: ["id"]
          },
        ]
      }
      generated_tests: {
        Row: {
          applied_at: string | null
          created_at: string
          created_by: string
          description: string | null
          id: string
          scan_result_id: string | null
          status: string
          test_code: string
          test_file_path: string
          test_framework: string
        }
        Insert: {
          applied_at?: string | null
          created_at?: string
          created_by: string
          description?: string | null
          id?: string
          scan_result_id?: string | null
          status?: string
          test_code: string
          test_file_path: string
          test_framework?: string
        }
        Update: {
          applied_at?: string | null
          created_at?: string
          created_by?: string
          description?: string | null
          id?: string
          scan_result_id?: string | null
          status?: string
          test_code?: string
          test_file_path?: string
          test_framework?: string
        }
        Relationships: [
          {
            foreignKeyName: "generated_tests_scan_result_id_fkey"
            columns: ["scan_result_id"]
            isOneToOne: false
            referencedRelation: "scan_results"
            referencedColumns: ["id"]
          },
        ]
      }
      hospital_departments: {
        Row: {
          created_at: string | null
          description: string | null
          icon: string | null
          id: string
          name: string
        }
        Insert: {
          created_at?: string | null
          description?: string | null
          icon?: string | null
          id?: string
          name: string
        }
        Update: {
          created_at?: string | null
          description?: string | null
          icon?: string | null
          id?: string
          name?: string
        }
        Relationships: []
      }
      identity_rules: {
        Row: {
          created_at: string | null
          fixed_answer: string
          id: string
          language: string | null
          priority: number | null
          question_pattern: string
        }
        Insert: {
          created_at?: string | null
          fixed_answer: string
          id?: string
          language?: string | null
          priority?: number | null
          question_pattern: string
        }
        Update: {
          created_at?: string | null
          fixed_answer?: string
          id?: string
          language?: string | null
          priority?: number | null
          question_pattern?: string
        }
        Relationships: []
      }
      job_applications: {
        Row: {
          ai_analysis: string | null
          applicant_id: string
          cover_letter: string | null
          created_at: string | null
          cv_url: string | null
          id: string
          job_id: string | null
          status: string | null
        }
        Insert: {
          ai_analysis?: string | null
          applicant_id: string
          cover_letter?: string | null
          created_at?: string | null
          cv_url?: string | null
          id?: string
          job_id?: string | null
          status?: string | null
        }
        Update: {
          ai_analysis?: string | null
          applicant_id?: string
          cover_letter?: string | null
          created_at?: string | null
          cv_url?: string | null
          id?: string
          job_id?: string | null
          status?: string | null
        }
        Relationships: [
          {
            foreignKeyName: "job_applications_job_id_fkey"
            columns: ["job_id"]
            isOneToOne: false
            referencedRelation: "job_postings"
            referencedColumns: ["id"]
          },
        ]
      }
      job_postings: {
        Row: {
          company_name: string | null
          created_at: string | null
          description: string | null
          employer_id: string
          id: string
          is_active: boolean | null
          job_type: string | null
          location: string | null
          requirements: string[] | null
          salary_range: string | null
          title: string
        }
        Insert: {
          company_name?: string | null
          created_at?: string | null
          description?: string | null
          employer_id: string
          id?: string
          is_active?: boolean | null
          job_type?: string | null
          location?: string | null
          requirements?: string[] | null
          salary_range?: string | null
          title: string
        }
        Update: {
          company_name?: string | null
          created_at?: string | null
          description?: string | null
          employer_id?: string
          id?: string
          is_active?: boolean | null
          job_type?: string | null
          location?: string | null
          requirements?: string[] | null
          salary_range?: string | null
          title?: string
        }
        Relationships: []
      }
      lawyers: {
        Row: {
          avatar_url: string | null
          consultation_fee: number | null
          created_at: string | null
          experience_years: number | null
          id: string
          name: string
          specialty: string | null
          user_id: string | null
        }
        Insert: {
          avatar_url?: string | null
          consultation_fee?: number | null
          created_at?: string | null
          experience_years?: number | null
          id?: string
          name: string
          specialty?: string | null
          user_id?: string | null
        }
        Update: {
          avatar_url?: string | null
          consultation_fee?: number | null
          created_at?: string | null
          experience_years?: number | null
          id?: string
          name?: string
          specialty?: string | null
          user_id?: string | null
        }
        Relationships: []
      }
      legal_cases: {
        Row: {
          case_type: string | null
          client_id: string
          created_at: string | null
          description: string | null
          documents: string[] | null
          id: string
          lawyer_id: string | null
          status: string | null
          title: string
        }
        Insert: {
          case_type?: string | null
          client_id: string
          created_at?: string | null
          description?: string | null
          documents?: string[] | null
          id?: string
          lawyer_id?: string | null
          status?: string | null
          title: string
        }
        Update: {
          case_type?: string | null
          client_id?: string
          created_at?: string | null
          description?: string | null
          documents?: string[] | null
          id?: string
          lawyer_id?: string | null
          status?: string | null
          title?: string
        }
        Relationships: [
          {
            foreignKeyName: "legal_cases_lawyer_id_fkey"
            columns: ["lawyer_id"]
            isOneToOne: false
            referencedRelation: "lawyers"
            referencedColumns: ["id"]
          },
        ]
      }
      legal_documents: {
        Row: {
          category: string | null
          created_at: string | null
          id: string
          template_content: string | null
          title: string
        }
        Insert: {
          category?: string | null
          created_at?: string | null
          id?: string
          template_content?: string | null
          title: string
        }
        Update: {
          category?: string | null
          created_at?: string | null
          id?: string
          template_content?: string | null
          title?: string
        }
        Relationships: []
      }
      marketing_campaigns: {
        Row: {
          analytics: Json | null
          content: string | null
          created_at: string | null
          id: string
          platform: string | null
          scheduled_at: string | null
          status: string | null
          title: string
          updated_at: string | null
          user_id: string
        }
        Insert: {
          analytics?: Json | null
          content?: string | null
          created_at?: string | null
          id?: string
          platform?: string | null
          scheduled_at?: string | null
          status?: string | null
          title: string
          updated_at?: string | null
          user_id: string
        }
        Update: {
          analytics?: Json | null
          content?: string | null
          created_at?: string | null
          id?: string
          platform?: string | null
          scheduled_at?: string | null
          status?: string | null
          title?: string
          updated_at?: string | null
          user_id?: string
        }
        Relationships: []
      }
      messages: {
        Row: {
          content: string
          created_at: string | null
          id: string
          language: string | null
          role: string
          user_id: string
        }
        Insert: {
          content: string
          created_at?: string | null
          id?: string
          language?: string | null
          role: string
          user_id: string
        }
        Update: {
          content?: string
          created_at?: string | null
          id?: string
          language?: string | null
          role?: string
          user_id?: string
        }
        Relationships: []
      }
      module_templates: {
        Row: {
          category: string
          created_at: string | null
          description: string | null
          id: string
          is_multi_tenant: boolean | null
          name: string
          slug: string
          template_config: Json
          updated_at: string | null
        }
        Insert: {
          category: string
          created_at?: string | null
          description?: string | null
          id?: string
          is_multi_tenant?: boolean | null
          name: string
          slug: string
          template_config: Json
          updated_at?: string | null
        }
        Update: {
          category?: string
          created_at?: string | null
          description?: string | null
          id?: string
          is_multi_tenant?: boolean | null
          name?: string
          slug?: string
          template_config?: Json
          updated_at?: string | null
        }
        Relationships: []
      }
      modules: {
        Row: {
          created_at: string | null
          description: string | null
          description_bn: string | null
          icon: string | null
          id: string
          is_active: boolean | null
          name: string
          name_bn: string
          order_index: number | null
          route: string
        }
        Insert: {
          created_at?: string | null
          description?: string | null
          description_bn?: string | null
          icon?: string | null
          id?: string
          is_active?: boolean | null
          name: string
          name_bn: string
          order_index?: number | null
          route: string
        }
        Update: {
          created_at?: string | null
          description?: string | null
          description_bn?: string | null
          icon?: string | null
          id?: string
          is_active?: boolean | null
          name?: string
          name_bn?: string
          order_index?: number | null
          route?: string
        }
        Relationships: []
      }
      news_articles: {
        Row: {
          author_id: string | null
          category: string | null
          content: string
          created_at: string | null
          id: string
          is_trending: boolean | null
          published_at: string | null
          summary: string | null
          thumbnail_url: string | null
          title: string
          views: number | null
        }
        Insert: {
          author_id?: string | null
          category?: string | null
          content: string
          created_at?: string | null
          id?: string
          is_trending?: boolean | null
          published_at?: string | null
          summary?: string | null
          thumbnail_url?: string | null
          title: string
          views?: number | null
        }
        Update: {
          author_id?: string | null
          category?: string | null
          content?: string
          created_at?: string | null
          id?: string
          is_trending?: boolean | null
          published_at?: string | null
          summary?: string | null
          thumbnail_url?: string | null
          title?: string
          views?: number | null
        }
        Relationships: []
      }
      offline_brain: {
        Row: {
          answer: string
          category: string | null
          id: string
          language: string | null
          question: string
          updated_at: string | null
        }
        Insert: {
          answer: string
          category?: string | null
          id?: string
          language?: string | null
          question: string
          updated_at?: string | null
        }
        Update: {
          answer?: string
          category?: string | null
          id?: string
          language?: string | null
          question?: string
          updated_at?: string | null
        }
        Relationships: []
      }
      patient_history: {
        Row: {
          created_at: string | null
          diagnosis: string | null
          doctor_id: string | null
          id: string
          patient_id: string
          prescription: string | null
          visit_date: string | null
        }
        Insert: {
          created_at?: string | null
          diagnosis?: string | null
          doctor_id?: string | null
          id?: string
          patient_id: string
          prescription?: string | null
          visit_date?: string | null
        }
        Update: {
          created_at?: string | null
          diagnosis?: string | null
          doctor_id?: string | null
          id?: string
          patient_id?: string
          prescription?: string | null
          visit_date?: string | null
        }
        Relationships: [
          {
            foreignKeyName: "patient_history_doctor_id_fkey"
            columns: ["doctor_id"]
            isOneToOne: false
            referencedRelation: "doctors"
            referencedColumns: ["id"]
          },
        ]
      }
      payment_requests: {
        Row: {
          amount: number
          created_at: string
          id: string
          note: string | null
          recipient_id: string
          requester_id: string
          status: string
          updated_at: string
        }
        Insert: {
          amount: number
          created_at?: string
          id?: string
          note?: string | null
          recipient_id: string
          requester_id: string
          status?: string
          updated_at?: string
        }
        Update: {
          amount?: number
          created_at?: string
          id?: string
          note?: string | null
          recipient_id?: string
          requester_id?: string
          status?: string
          updated_at?: string
        }
        Relationships: [
          {
            foreignKeyName: "payment_requests_recipient_id_fkey"
            columns: ["recipient_id"]
            isOneToOne: false
            referencedRelation: "profiles"
            referencedColumns: ["id"]
          },
          {
            foreignKeyName: "payment_requests_requester_id_fkey"
            columns: ["requester_id"]
            isOneToOne: false
            referencedRelation: "profiles"
            referencedColumns: ["id"]
          },
        ]
      }
      profiles: {
        Row: {
          avatar_url: string | null
          created_at: string | null
          full_name: string
          id: string
          language_preference: string | null
          phone: string | null
          updated_at: string | null
        }
        Insert: {
          avatar_url?: string | null
          created_at?: string | null
          full_name: string
          id: string
          language_preference?: string | null
          phone?: string | null
          updated_at?: string | null
        }
        Update: {
          avatar_url?: string | null
          created_at?: string | null
          full_name?: string
          id?: string
          language_preference?: string | null
          phone?: string | null
          updated_at?: string | null
        }
        Relationships: []
      }
      project_files: {
        Row: {
          content: string | null
          created_at: string | null
          file_name: string
          file_path: string
          file_type: string
          id: string
          parent_id: string | null
          project_id: string
          updated_at: string | null
          user_id: string
        }
        Insert: {
          content?: string | null
          created_at?: string | null
          file_name: string
          file_path: string
          file_type?: string
          id?: string
          parent_id?: string | null
          project_id?: string
          updated_at?: string | null
          user_id: string
        }
        Update: {
          content?: string | null
          created_at?: string | null
          file_name?: string
          file_path?: string
          file_type?: string
          id?: string
          parent_id?: string | null
          project_id?: string
          updated_at?: string | null
          user_id?: string
        }
        Relationships: []
      }
      reminders: {
        Row: {
          created_at: string | null
          description: string | null
          id: string
          is_completed: boolean | null
          remind_at: string
          title: string
          user_id: string
        }
        Insert: {
          created_at?: string | null
          description?: string | null
          id?: string
          is_completed?: boolean | null
          remind_at: string
          title: string
          user_id: string
        }
        Update: {
          created_at?: string | null
          description?: string | null
          id?: string
          is_completed?: boolean | null
          remind_at?: string
          title?: string
          user_id?: string
        }
        Relationships: []
      }
      safety_filter: {
        Row: {
          category: string
          created_at: string | null
          enabled: boolean | null
          id: string
          rule: string
          severity: string | null
        }
        Insert: {
          category: string
          created_at?: string | null
          enabled?: boolean | null
          id?: string
          rule: string
          severity?: string | null
        }
        Update: {
          category?: string
          created_at?: string | null
          enabled?: boolean | null
          id?: string
          rule?: string
          severity?: string | null
        }
        Relationships: []
      }
      scan_results: {
        Row: {
          created_at: string
          details: Json | null
          file_path: string | null
          id: string
          issue_type: string
          message: string
          resolved: boolean | null
          scan_type: string
          severity: string
        }
        Insert: {
          created_at?: string
          details?: Json | null
          file_path?: string | null
          id?: string
          issue_type: string
          message: string
          resolved?: boolean | null
          scan_type: string
          severity?: string
        }
        Update: {
          created_at?: string
          details?: Json | null
          file_path?: string | null
          id?: string
          issue_type?: string
          message?: string
          resolved?: boolean | null
          scan_type?: string
          severity?: string
        }
        Relationships: []
      }
      seba_leads: {
        Row: {
          company: string | null
          country: string | null
          created_at: string | null
          email: string
          id: string
          message: string | null
          module_id: string | null
          name: string
          phone: string | null
        }
        Insert: {
          company?: string | null
          country?: string | null
          created_at?: string | null
          email: string
          id?: string
          message?: string | null
          module_id?: string | null
          name: string
          phone?: string | null
        }
        Update: {
          company?: string | null
          country?: string | null
          created_at?: string | null
          email?: string
          id?: string
          message?: string | null
          module_id?: string | null
          name?: string
          phone?: string | null
        }
        Relationships: [
          {
            foreignKeyName: "seba_leads_module_id_fkey"
            columns: ["module_id"]
            isOneToOne: false
            referencedRelation: "seba_modules"
            referencedColumns: ["id"]
          },
        ]
      }
      seba_modules: {
        Row: {
          business_model: string | null
          category: string
          created_at: string | null
          icon: string | null
          id: string
          is_public_unlocked: boolean | null
          is_visible_public: boolean | null
          key_features: string | null
          key_features_bn: string | null
          name: string
          name_bn: string | null
          notes_internal: string | null
          overview: string | null
          overview_bn: string | null
          progress_percent: number | null
          short_tagline: string | null
          short_tagline_bn: string | null
          slug: string
          status: string | null
          target_users: string | null
          updated_at: string | null
        }
        Insert: {
          business_model?: string | null
          category: string
          created_at?: string | null
          icon?: string | null
          id?: string
          is_public_unlocked?: boolean | null
          is_visible_public?: boolean | null
          key_features?: string | null
          key_features_bn?: string | null
          name: string
          name_bn?: string | null
          notes_internal?: string | null
          overview?: string | null
          overview_bn?: string | null
          progress_percent?: number | null
          short_tagline?: string | null
          short_tagline_bn?: string | null
          slug: string
          status?: string | null
          target_users?: string | null
          updated_at?: string | null
        }
        Update: {
          business_model?: string | null
          category?: string
          created_at?: string | null
          icon?: string | null
          id?: string
          is_public_unlocked?: boolean | null
          is_visible_public?: boolean | null
          key_features?: string | null
          key_features_bn?: string | null
          name?: string
          name_bn?: string | null
          notes_internal?: string | null
          overview?: string | null
          overview_bn?: string | null
          progress_percent?: number | null
          short_tagline?: string | null
          short_tagline_bn?: string | null
          slug?: string
          status?: string | null
          target_users?: string | null
          updated_at?: string | null
        }
        Relationships: []
      }
      sf_module_blueprints: {
        Row: {
          api_routes: Json | null
          backend_stack: string | null
          complexity: string | null
          created_at: string | null
          created_by: string
          description: string | null
          entities: Json | null
          frontend_stack: string | null
          generated_files: Json | null
          generation_log: string | null
          id: string
          menu_items: Json | null
          name: string
          natural_description: string | null
          permissions: Json | null
          relationships: Json | null
          slug: string
          status: string | null
          tags: string[] | null
          ui_pages: Json | null
          updated_at: string | null
          version: string | null
        }
        Insert: {
          api_routes?: Json | null
          backend_stack?: string | null
          complexity?: string | null
          created_at?: string | null
          created_by: string
          description?: string | null
          entities?: Json | null
          frontend_stack?: string | null
          generated_files?: Json | null
          generation_log?: string | null
          id?: string
          menu_items?: Json | null
          name: string
          natural_description?: string | null
          permissions?: Json | null
          relationships?: Json | null
          slug: string
          status?: string | null
          tags?: string[] | null
          ui_pages?: Json | null
          updated_at?: string | null
          version?: string | null
        }
        Update: {
          api_routes?: Json | null
          backend_stack?: string | null
          complexity?: string | null
          created_at?: string | null
          created_by?: string
          description?: string | null
          entities?: Json | null
          frontend_stack?: string | null
          generated_files?: Json | null
          generation_log?: string | null
          id?: string
          menu_items?: Json | null
          name?: string
          natural_description?: string | null
          permissions?: Json | null
          relationships?: Json | null
          slug?: string
          status?: string | null
          tags?: string[] | null
          ui_pages?: Json | null
          updated_at?: string | null
          version?: string | null
        }
        Relationships: []
      }
      sf_modules: {
        Row: {
          author: string | null
          blueprint_id: string | null
          category: string | null
          created_at: string | null
          description: string | null
          frontend_entry: string | null
          icon: string | null
          id: string
          is_active: boolean | null
          is_system: boolean | null
          name: string
          route: string
          slug: string
          tags: string[] | null
          updated_at: string | null
          version: string | null
        }
        Insert: {
          author?: string | null
          blueprint_id?: string | null
          category?: string | null
          created_at?: string | null
          description?: string | null
          frontend_entry?: string | null
          icon?: string | null
          id?: string
          is_active?: boolean | null
          is_system?: boolean | null
          name: string
          route: string
          slug: string
          tags?: string[] | null
          updated_at?: string | null
          version?: string | null
        }
        Update: {
          author?: string | null
          blueprint_id?: string | null
          category?: string | null
          created_at?: string | null
          description?: string | null
          frontend_entry?: string | null
          icon?: string | null
          id?: string
          is_active?: boolean | null
          is_system?: boolean | null
          name?: string
          route?: string
          slug?: string
          tags?: string[] | null
          updated_at?: string | null
          version?: string | null
        }
        Relationships: [
          {
            foreignKeyName: "sf_modules_blueprint_id_fkey"
            columns: ["blueprint_id"]
            isOneToOne: false
            referencedRelation: "sf_module_blueprints"
            referencedColumns: ["id"]
          },
        ]
      }
      sf_system_versions: {
        Row: {
          affected_files: Json | null
          applied_at: string | null
          applied_by: string | null
          created_at: string | null
          description: string | null
          detection_method: string | null
          diff_preview: string | null
          id: string
          optimization_score: number | null
          patch_content: string | null
          rollback_available: boolean | null
          status: string | null
          upgrade_type: string
          version: string
        }
        Insert: {
          affected_files?: Json | null
          applied_at?: string | null
          applied_by?: string | null
          created_at?: string | null
          description?: string | null
          detection_method?: string | null
          diff_preview?: string | null
          id?: string
          optimization_score?: number | null
          patch_content?: string | null
          rollback_available?: boolean | null
          status?: string | null
          upgrade_type: string
          version: string
        }
        Update: {
          affected_files?: Json | null
          applied_at?: string | null
          applied_by?: string | null
          created_at?: string | null
          description?: string | null
          detection_method?: string | null
          diff_preview?: string | null
          id?: string
          optimization_score?: number | null
          patch_content?: string | null
          rollback_available?: boolean | null
          status?: string | null
          upgrade_type?: string
          version?: string
        }
        Relationships: []
      }
      smart_subscriptions: {
        Row: {
          created_at: string | null
          expires_at: string
          id: string
          is_active: boolean | null
          plan: string
          updated_at: string | null
          user_id: string
        }
        Insert: {
          created_at?: string | null
          expires_at: string
          id?: string
          is_active?: boolean | null
          plan?: string
          updated_at?: string | null
          user_id: string
        }
        Update: {
          created_at?: string | null
          expires_at?: string
          id?: string
          is_active?: boolean | null
          plan?: string
          updated_at?: string | null
          user_id?: string
        }
        Relationships: []
      }
      smart_wallets: {
        Row: {
          balance: number
          created_at: string | null
          currency: string | null
          id: string
          updated_at: string | null
          user_id: string
        }
        Insert: {
          balance?: number
          created_at?: string | null
          currency?: string | null
          id?: string
          updated_at?: string | null
          user_id: string
        }
        Update: {
          balance?: number
          created_at?: string | null
          currency?: string | null
          id?: string
          updated_at?: string | null
          user_id?: string
        }
        Relationships: []
      }
      tour_bookings: {
        Row: {
          booking_date: string
          created_at: string | null
          id: string
          package_id: string | null
          status: string | null
          travelers_count: number | null
          user_id: string
        }
        Insert: {
          booking_date: string
          created_at?: string | null
          id?: string
          package_id?: string | null
          status?: string | null
          travelers_count?: number | null
          user_id: string
        }
        Update: {
          booking_date?: string
          created_at?: string | null
          id?: string
          package_id?: string | null
          status?: string | null
          travelers_count?: number | null
          user_id?: string
        }
        Relationships: [
          {
            foreignKeyName: "tour_bookings_package_id_fkey"
            columns: ["package_id"]
            isOneToOne: false
            referencedRelation: "tour_packages"
            referencedColumns: ["id"]
          },
        ]
      }
      tour_packages: {
        Row: {
          created_at: string | null
          description: string | null
          destinations: string[] | null
          duration_days: number | null
          id: string
          includes: string[] | null
          price: number | null
          title: string
        }
        Insert: {
          created_at?: string | null
          description?: string | null
          destinations?: string[] | null
          duration_days?: number | null
          id?: string
          includes?: string[] | null
          price?: number | null
          title: string
        }
        Update: {
          created_at?: string | null
          description?: string | null
          destinations?: string[] | null
          duration_days?: number | null
          id?: string
          includes?: string[] | null
          price?: number | null
          title?: string
        }
        Relationships: []
      }
      tourist_hotels: {
        Row: {
          amenities: string[] | null
          created_at: string | null
          id: string
          images: string[] | null
          location: string | null
          name: string
          price_per_night: number | null
          rating: number | null
        }
        Insert: {
          amenities?: string[] | null
          created_at?: string | null
          id?: string
          images?: string[] | null
          location?: string | null
          name: string
          price_per_night?: number | null
          rating?: number | null
        }
        Update: {
          amenities?: string[] | null
          created_at?: string | null
          id?: string
          images?: string[] | null
          location?: string | null
          name?: string
          price_per_night?: number | null
          rating?: number | null
        }
        Relationships: []
      }
      tourist_places: {
        Row: {
          category: string | null
          created_at: string | null
          description: string | null
          id: string
          images: string[] | null
          location: string | null
          name: string
          rating: number | null
        }
        Insert: {
          category?: string | null
          created_at?: string | null
          description?: string | null
          id?: string
          images?: string[] | null
          location?: string | null
          name: string
          rating?: number | null
        }
        Update: {
          category?: string | null
          created_at?: string | null
          description?: string | null
          id?: string
          images?: string[] | null
          location?: string | null
          name?: string
          rating?: number | null
        }
        Relationships: []
      }
      transactions: {
        Row: {
          amount: number
          created_at: string
          id: string
          note: string | null
          recipient_id: string
          sender_id: string
          status: string
          tags: string[] | null
          type: string
          updated_at: string
        }
        Insert: {
          amount: number
          created_at?: string
          id?: string
          note?: string | null
          recipient_id: string
          sender_id: string
          status?: string
          tags?: string[] | null
          type?: string
          updated_at?: string
        }
        Update: {
          amount?: number
          created_at?: string
          id?: string
          note?: string | null
          recipient_id?: string
          sender_id?: string
          status?: string
          tags?: string[] | null
          type?: string
          updated_at?: string
        }
        Relationships: [
          {
            foreignKeyName: "transactions_recipient_id_fkey"
            columns: ["recipient_id"]
            isOneToOne: false
            referencedRelation: "profiles"
            referencedColumns: ["id"]
          },
          {
            foreignKeyName: "transactions_sender_id_fkey"
            columns: ["sender_id"]
            isOneToOne: false
            referencedRelation: "profiles"
            referencedColumns: ["id"]
          },
        ]
      }
      user_cvs: {
        Row: {
          created_at: string | null
          cv_data: Json | null
          cv_url: string | null
          id: string
          updated_at: string | null
          user_id: string
        }
        Insert: {
          created_at?: string | null
          cv_data?: Json | null
          cv_url?: string | null
          id?: string
          updated_at?: string | null
          user_id: string
        }
        Update: {
          created_at?: string | null
          cv_data?: Json | null
          cv_url?: string | null
          id?: string
          updated_at?: string | null
          user_id?: string
        }
        Relationships: []
      }
      user_memory: {
        Row: {
          created_at: string | null
          id: string
          is_synced: boolean | null
          local_only: boolean | null
          memory_key: string
          memory_type: string
          memory_value: Json
          project_id: string | null
          sync_priority: number | null
          updated_at: string | null
          user_id: string
        }
        Insert: {
          created_at?: string | null
          id?: string
          is_synced?: boolean | null
          local_only?: boolean | null
          memory_key: string
          memory_type: string
          memory_value: Json
          project_id?: string | null
          sync_priority?: number | null
          updated_at?: string | null
          user_id: string
        }
        Update: {
          created_at?: string | null
          id?: string
          is_synced?: boolean | null
          local_only?: boolean | null
          memory_key?: string
          memory_type?: string
          memory_value?: Json
          project_id?: string | null
          sync_priority?: number | null
          updated_at?: string | null
          user_id?: string
        }
        Relationships: []
      }
      user_roles: {
        Row: {
          created_at: string | null
          id: string
          role: Database["public"]["Enums"]["app_role"]
          user_id: string
        }
        Insert: {
          created_at?: string | null
          id?: string
          role: Database["public"]["Enums"]["app_role"]
          user_id: string
        }
        Update: {
          created_at?: string | null
          id?: string
          role?: Database["public"]["Enums"]["app_role"]
          user_id?: string
        }
        Relationships: []
      }
      wallet_transactions: {
        Row: {
          amount: number
          created_at: string | null
          description: string | null
          id: string
          type: string
          user_id: string
        }
        Insert: {
          amount: number
          created_at?: string | null
          description?: string | null
          id?: string
          type: string
          user_id: string
        }
        Update: {
          amount?: number
          created_at?: string | null
          description?: string | null
          id?: string
          type?: string
          user_id?: string
        }
        Relationships: []
      }
      wallets: {
        Row: {
          balance: number
          created_at: string
          currency: string
          id: string
          updated_at: string
          user_id: string
        }
        Insert: {
          balance?: number
          created_at?: string
          currency?: string
          id?: string
          updated_at?: string
          user_id: string
        }
        Update: {
          balance?: number
          created_at?: string
          currency?: string
          id?: string
          updated_at?: string
          user_id?: string
        }
        Relationships: []
      }
      webrtc_signals: {
        Row: {
          call_id: string
          created_at: string | null
          from_user_id: string
          id: string
          signal_data: Json
          signal_type: string
          to_user_id: string
        }
        Insert: {
          call_id: string
          created_at?: string | null
          from_user_id: string
          id?: string
          signal_data: Json
          signal_type: string
          to_user_id: string
        }
        Update: {
          call_id?: string
          created_at?: string | null
          from_user_id?: string
          id?: string
          signal_data?: Json
          signal_type?: string
          to_user_id?: string
        }
        Relationships: [
          {
            foreignKeyName: "webrtc_signals_call_id_fkey"
            columns: ["call_id"]
            isOneToOne: false
            referencedRelation: "calls"
            referencedColumns: ["id"]
          },
        ]
      }
    }
    Views: {
      [_ in never]: never
    }
    Functions: {
      execute_wallet_transfer: {
        Args: {
          _amount: number
          _note?: string
          _recipient_id: string
          _sender_id: string
        }
        Returns: Json
      }
      has_role: {
        Args: {
          _role: Database["public"]["Enums"]["app_role"]
          _user_id: string
        }
        Returns: boolean
      }
      is_core_brain_owner: { Args: never; Returns: boolean }
      trigger_core_brain_scan: { Args: never; Returns: undefined }
    }
    Enums: {
      app_role: "admin" | "user" | "owner"
    }
    CompositeTypes: {
      [_ in never]: never
    }
  }
}

type DatabaseWithoutInternals = Omit<Database, "__InternalSupabase">

type DefaultSchema = DatabaseWithoutInternals[Extract<keyof Database, "public">]

export type Tables<
  DefaultSchemaTableNameOrOptions extends
    | keyof (DefaultSchema["Tables"] & DefaultSchema["Views"])
    | { schema: keyof DatabaseWithoutInternals },
  TableName extends DefaultSchemaTableNameOrOptions extends {
    schema: keyof DatabaseWithoutInternals
  }
    ? keyof (DatabaseWithoutInternals[DefaultSchemaTableNameOrOptions["schema"]]["Tables"] &
        DatabaseWithoutInternals[DefaultSchemaTableNameOrOptions["schema"]]["Views"])
    : never = never,
> = DefaultSchemaTableNameOrOptions extends {
  schema: keyof DatabaseWithoutInternals
}
  ? (DatabaseWithoutInternals[DefaultSchemaTableNameOrOptions["schema"]]["Tables"] &
      DatabaseWithoutInternals[DefaultSchemaTableNameOrOptions["schema"]]["Views"])[TableName] extends {
      Row: infer R
    }
    ? R
    : never
  : DefaultSchemaTableNameOrOptions extends keyof (DefaultSchema["Tables"] &
        DefaultSchema["Views"])
    ? (DefaultSchema["Tables"] &
        DefaultSchema["Views"])[DefaultSchemaTableNameOrOptions] extends {
        Row: infer R
      }
      ? R
      : never
    : never

export type TablesInsert<
  DefaultSchemaTableNameOrOptions extends
    | keyof DefaultSchema["Tables"]
    | { schema: keyof DatabaseWithoutInternals },
  TableName extends DefaultSchemaTableNameOrOptions extends {
    schema: keyof DatabaseWithoutInternals
  }
    ? keyof DatabaseWithoutInternals[DefaultSchemaTableNameOrOptions["schema"]]["Tables"]
    : never = never,
> = DefaultSchemaTableNameOrOptions extends {
  schema: keyof DatabaseWithoutInternals
}
  ? DatabaseWithoutInternals[DefaultSchemaTableNameOrOptions["schema"]]["Tables"][TableName] extends {
      Insert: infer I
    }
    ? I
    : never
  : DefaultSchemaTableNameOrOptions extends keyof DefaultSchema["Tables"]
    ? DefaultSchema["Tables"][DefaultSchemaTableNameOrOptions] extends {
        Insert: infer I
      }
      ? I
      : never
    : never

export type TablesUpdate<
  DefaultSchemaTableNameOrOptions extends
    | keyof DefaultSchema["Tables"]
    | { schema: keyof DatabaseWithoutInternals },
  TableName extends DefaultSchemaTableNameOrOptions extends {
    schema: keyof DatabaseWithoutInternals
  }
    ? keyof DatabaseWithoutInternals[DefaultSchemaTableNameOrOptions["schema"]]["Tables"]
    : never = never,
> = DefaultSchemaTableNameOrOptions extends {
  schema: keyof DatabaseWithoutInternals
}
  ? DatabaseWithoutInternals[DefaultSchemaTableNameOrOptions["schema"]]["Tables"][TableName] extends {
      Update: infer U
    }
    ? U
    : never
  : DefaultSchemaTableNameOrOptions extends keyof DefaultSchema["Tables"]
    ? DefaultSchema["Tables"][DefaultSchemaTableNameOrOptions] extends {
        Update: infer U
      }
      ? U
      : never
    : never

export type Enums<
  DefaultSchemaEnumNameOrOptions extends
    | keyof DefaultSchema["Enums"]
    | { schema: keyof DatabaseWithoutInternals },
  EnumName extends DefaultSchemaEnumNameOrOptions extends {
    schema: keyof DatabaseWithoutInternals
  }
    ? keyof DatabaseWithoutInternals[DefaultSchemaEnumNameOrOptions["schema"]]["Enums"]
    : never = never,
> = DefaultSchemaEnumNameOrOptions extends {
  schema: keyof DatabaseWithoutInternals
}
  ? DatabaseWithoutInternals[DefaultSchemaEnumNameOrOptions["schema"]]["Enums"][EnumName]
  : DefaultSchemaEnumNameOrOptions extends keyof DefaultSchema["Enums"]
    ? DefaultSchema["Enums"][DefaultSchemaEnumNameOrOptions]
    : never

export type CompositeTypes<
  PublicCompositeTypeNameOrOptions extends
    | keyof DefaultSchema["CompositeTypes"]
    | { schema: keyof DatabaseWithoutInternals },
  CompositeTypeName extends PublicCompositeTypeNameOrOptions extends {
    schema: keyof DatabaseWithoutInternals
  }
    ? keyof DatabaseWithoutInternals[PublicCompositeTypeNameOrOptions["schema"]]["CompositeTypes"]
    : never = never,
> = PublicCompositeTypeNameOrOptions extends {
  schema: keyof DatabaseWithoutInternals
}
  ? DatabaseWithoutInternals[PublicCompositeTypeNameOrOptions["schema"]]["CompositeTypes"][CompositeTypeName]
  : PublicCompositeTypeNameOrOptions extends keyof DefaultSchema["CompositeTypes"]
    ? DefaultSchema["CompositeTypes"][PublicCompositeTypeNameOrOptions]
    : never

export const Constants = {
  public: {
    Enums: {
      app_role: ["admin", "user", "owner"],
    },
  },
} as const
