// Translation keys and utilities
// This is the foundation for module translations

export type TranslationKey = string;

// Common translations used across all modules
export const COMMON_TRANSLATIONS: Record<string, Record<string, string>> = {
  // Navigation
  'nav.home': {
    en: 'Home',
    bn: 'হোম',
    ar: 'الرئيسية',
    hi: 'होम',
    ur: 'ہوم',
    es: 'Inicio',
    fr: 'Accueil',
    de: 'Startseite',
    zh: '首页',
  },
  'nav.chat': {
    en: 'Chat',
    bn: 'চ্যাট',
    ar: 'دردشة',
    hi: 'चैट',
    ur: 'چیٹ',
    es: 'Chat',
    fr: 'Discussion',
    de: 'Chat',
    zh: '聊天',
  },
  'nav.modules': {
    en: 'Modules',
    bn: 'মডিউল',
    ar: 'الوحدات',
    hi: 'मॉड्यूल',
    ur: 'ماڈیولز',
    es: 'Módulos',
    fr: 'Modules',
    de: 'Module',
    zh: '模块',
  },
  
  // Actions
  'action.save': {
    en: 'Save',
    bn: 'সংরক্ষণ',
    ar: 'حفظ',
    hi: 'सहेजें',
    ur: 'محفوظ کریں',
    es: 'Guardar',
    fr: 'Enregistrer',
    de: 'Speichern',
    zh: '保存',
  },
  'action.cancel': {
    en: 'Cancel',
    bn: 'বাতিল',
    ar: 'إلغاء',
    hi: 'रद्द करें',
    ur: 'منسوخ کریں',
    es: 'Cancelar',
    fr: 'Annuler',
    de: 'Abbrechen',
    zh: '取消',
  },
  'action.delete': {
    en: 'Delete',
    bn: 'মুছে ফেলুন',
    ar: 'حذف',
    hi: 'हटाएं',
    ur: 'حذف کریں',
    es: 'Eliminar',
    fr: 'Supprimer',
    de: 'Löschen',
    zh: '删除',
  },
  'action.edit': {
    en: 'Edit',
    bn: 'সম্পাদনা',
    ar: 'تعديل',
    hi: 'संपादित करें',
    ur: 'ترمیم کریں',
    es: 'Editar',
    fr: 'Modifier',
    de: 'Bearbeiten',
    zh: '编辑',
  },
  'action.create': {
    en: 'Create',
    bn: 'তৈরি করুন',
    ar: 'إنشاء',
    hi: 'बनाएं',
    ur: 'بنائیں',
    es: 'Crear',
    fr: 'Créer',
    de: 'Erstellen',
    zh: '创建',
  },
  'action.search': {
    en: 'Search',
    bn: 'খুঁজুন',
    ar: 'بحث',
    hi: 'खोजें',
    ur: 'تلاش کریں',
    es: 'Buscar',
    fr: 'Rechercher',
    de: 'Suchen',
    zh: '搜索',
  },
  
  // Status messages
  'status.loading': {
    en: 'Loading...',
    bn: 'লোড হচ্ছে...',
    ar: 'جاري التحميل...',
    hi: 'लोड हो रहा है...',
    ur: 'لوڈ ہو رہا ہے...',
    es: 'Cargando...',
    fr: 'Chargement...',
    de: 'Lädt...',
    zh: '加载中...',
  },
  'status.success': {
    en: 'Success',
    bn: 'সফল',
    ar: 'نجح',
    hi: 'सफल',
    ur: 'کامیاب',
    es: 'Éxito',
    fr: 'Succès',
    de: 'Erfolg',
    zh: '成功',
  },
  'status.error': {
    en: 'Error',
    bn: 'ত্রুটি',
    ar: 'خطأ',
    hi: 'त्रुटि',
    ur: 'خرابی',
    es: 'Error',
    fr: 'Erreur',
    de: 'Fehler',
    zh: '错误',
  },
  
  // Smart Friend
  'smartfriend.title': {
    en: 'Smart Friend',
    bn: 'স্মার্ট ফ্রেন্ড',
    ar: 'صديق ذكي',
    hi: 'स्मार्ट फ्रेंड',
    ur: 'سمارٹ دوست',
    es: 'Amigo Inteligente',
    fr: 'Ami Intelligent',
    de: 'Kluger Freund',
    zh: '智能朋友',
  },
  'smartfriend.placeholder': {
    en: 'Type your message...',
    bn: 'আপনার বার্তা লিখুন...',
    ar: 'اكتب رسالتك...',
    hi: 'अपना संदेश टाइप करें...',
    ur: 'اپنا پیغام ٹائپ کریں...',
    es: 'Escribe tu mensaje...',
    fr: 'Tapez votre message...',
    de: 'Geben Sie Ihre Nachricht ein...',
    zh: '输入您的消息...',
  },
  
  // Modules
  'module.academy': {
    en: 'Smart Academy',
    bn: 'স্মার্ট একাডেমি',
    ar: 'الأكاديمية الذكية',
    hi: 'स्मार्ट अकादमी',
    ur: 'سمارٹ اکیڈمی',
    es: 'Academia Inteligente',
    fr: 'Académie Intelligente',
    de: 'Kluge Akademie',
    zh: '智能学院',
  },
  'module.hospital': {
    en: 'Smart Doctor',
    bn: 'স্মার্ট ডাক্তার',
    ar: 'طبيب ذكي',
    hi: 'स्मार्ट डॉक्टर',
    ur: 'سمارٹ ڈاکٹر',
    es: 'Doctor Inteligente',
    fr: 'Médecin Intelligent',
    de: 'Kluger Arzt',
    zh: '智能医生',
  },
  'module.bazar': {
    en: 'Smart Bazar',
    bn: 'স্মার্ট বাজার',
    ar: 'السوق الذكي',
    hi: 'स्मार्ट बाजार',
    ur: 'سمارٹ بازار',
    es: 'Bazar Inteligente',
    fr: 'Bazar Intelligent',
    de: 'Kluger Basar',
    zh: '智能市场',
  },
};

// Translation utility function
export const translate = (key: string, language: string, fallback?: string): string => {
  const translation = COMMON_TRANSLATIONS[key];
  
  if (!translation) {
    return fallback || key;
  }
  
  return translation[language] || translation['en'] || fallback || key;
};

// Hook-friendly translation function
export const useTranslate = (language: string) => {
  return (key: string, fallback?: string) => translate(key, language, fallback);
};
