import { Button } from "@/components/ui/button";
import { Card } from "@/components/ui/card";
import { Download, Package } from "lucide-react";
import { zipBuilder } from "@/core/exporter/zip.builder";
import { toast } from "sonner";

const BuildExport = () => {
  const handleDownload = async () => {
    try {
      toast.loading("Building production ZIP...");
      
      const blob = await zipBuilder.buildProductionZip("smart-friend", []);
      
      toast.dismiss();
      toast.success("Production ZIP ready!");
      
      zipBuilder.downloadZip(blob, "smart-friend-production.zip");
    } catch (error) {
      toast.dismiss();
      toast.error("Failed to build ZIP");
      console.error(error);
    }
  };

  return (
    <div className="min-h-screen bg-background p-8">
      <div className="max-w-4xl mx-auto space-y-8">
        <div className="text-center space-y-4">
          <Package className="w-16 h-16 mx-auto text-primary" />
          <h1 className="text-4xl font-bold text-foreground">Build & Export</h1>
          <p className="text-muted-foreground text-lg">
            Download your production-ready Smart Friend package
          </p>
        </div>

        <Card className="p-8">
          <div className="space-y-6">
            <div>
              <h2 className="text-2xl font-semibold text-foreground mb-2">
                Production Package
              </h2>
              <p className="text-muted-foreground">
                This ZIP contains all configuration files needed to deploy your project to cPanel, Netlify, or Vercel.
              </p>
            </div>

            <Button
              onClick={handleDownload}
              size="lg"
              className="w-full text-lg gap-2"
            >
              <Download className="w-5 h-5" />
              Download Production ZIP
            </Button>

            <div className="pt-4 border-t space-y-2">
              <h3 className="font-semibold text-foreground">Package includes:</h3>
              <ul className="space-y-1 text-sm text-muted-foreground">
                <li>✓ package.json</li>
                <li>✓ vite.config.ts</li>
                <li>✓ tsconfig.json</li>
                <li>✓ tailwind.config.ts</li>
                <li>✓ .env.example</li>
                <li>✓ .htaccess (for cPanel)</li>
                <li>✓ README-DEPLOY.md (deployment guide)</li>
              </ul>
            </div>
          </div>
        </Card>

        <Card className="p-6 bg-muted/50">
          <h3 className="font-semibold text-foreground mb-3">Quick Deploy Steps:</h3>
          <ol className="space-y-2 text-sm text-muted-foreground list-decimal list-inside">
            <li>Extract the downloaded ZIP</li>
            <li>Run: npm install</li>
            <li>Run: npm run build</li>
            <li>Upload the /dist folder to your hosting</li>
          </ol>
        </Card>
      </div>
    </div>
  );
};

export default BuildExport;
