import { useState } from "react";
import { IDELayout } from "@/components/ide/IDELayout";
import { ModuleGenerator } from "@/components/ide/ModuleGenerator";
import { MemorySettings } from "@/components/ide/MemorySettings";
import { WelcomeDashboard } from "@/components/ide/WelcomeDashboard";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";
import { Code2, Package, Brain, Home } from "lucide-react";

export type ViewType = "home" | "chat" | "visual-edits" | "files" | "code" | "preview" | "publish" | "settings";

const CodeBuilder = () => {
  const [projectId] = useState(() => crypto.randomUUID());
  const [activeTab, setActiveTab] = useState<"home" | "ide" | "modules" | "memory">("home");
  const [selectedFile, setSelectedFile] = useState<string | null>(null);

  return (
    <div className="h-screen flex flex-col bg-background">
      <div className="border-b border-border bg-card">
        <Tabs value={activeTab} onValueChange={(v) => setActiveTab(v as any)}>
          <TabsList className="w-full justify-start rounded-none border-b-0">
            <TabsTrigger value="home" className="gap-2">
              <Home className="h-4 w-4" />
              Home
            </TabsTrigger>
            <TabsTrigger value="ide" className="gap-2">
              <Code2 className="h-4 w-4" />
              IDE
            </TabsTrigger>
            <TabsTrigger value="modules" className="gap-2">
              <Package className="h-4 w-4" />
              Modules
            </TabsTrigger>
            <TabsTrigger value="memory" className="gap-2">
              <Brain className="h-4 w-4" />
              Memory
            </TabsTrigger>
          </TabsList>
        </Tabs>
      </div>

      <div className="flex-1 overflow-hidden">
        {activeTab === "home" && <WelcomeDashboard onNavigate={setActiveTab} />}
        {activeTab === "ide" && <IDELayout projectId={projectId} />}
        {activeTab === "modules" && (
          <div className="h-full overflow-auto">
            <ModuleGenerator projectId={projectId} />
          </div>
        )}
        {activeTab === "memory" && (
          <div className="h-full overflow-auto">
            <MemorySettings projectId={projectId} />
          </div>
        )}
      </div>
    </div>
  );
};

export default CodeBuilder;
