import { Button } from "@/components/ui/button";
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { useNavigate } from "react-router-dom";
import { useLanguage } from "@/hooks/useLanguage";
import { 
  Brain, MessageSquare, Globe, Zap, Shield, Award,
  GraduationCap, Hospital, ShoppingBag, Plane, Newspaper,
  Briefcase, Scale, Palette, TrendingUp, Phone
} from "lucide-react";

export default function Landing() {
  const navigate = useNavigate();
  const { t } = useLanguage();

  const modules = [
    { icon: GraduationCap, name: "Smart Academy", desc: "Complete education platform with AI tutoring" },
    { icon: Hospital, name: "Smart Hospital", desc: "Healthcare management & doctor appointments" },
    { icon: ShoppingBag, name: "Smart Bazar", desc: "Multi-vendor e-commerce marketplace" },
    { icon: Plane, name: "Smart Tourist", desc: "Travel planning & hotel bookings" },
    { icon: Newspaper, name: "Smart News", desc: "Real-time news aggregation & summaries" },
    { icon: Briefcase, name: "Smart Job", desc: "Job portal with AI-powered matching" },
    { icon: Scale, name: "Smart Lawyer", desc: "Legal consultation & case management" },
    { icon: Palette, name: "Smart Design Hub", desc: "AI-powered design tools" },
    { icon: TrendingUp, name: "Smart Marketer", desc: "Marketing automation & analytics" },
    { icon: Phone, name: "Smart Call Center", desc: "AI-powered customer support" }
  ];

  const features = [
    { icon: Globe, title: "100+ Languages", desc: "Communicate in any language with AI translation" },
    { icon: MessageSquare, title: "Voice & Video", desc: "Real-time voice and video calling with AI" },
    { icon: Brain, title: "AI-Powered", desc: "Advanced AI assistance for all your needs" },
    { icon: Zap, title: "Lightning Fast", desc: "Optimized performance with PWA technology" },
    { icon: Shield, title: "Secure & Private", desc: "Bank-level security with encryption" },
    { icon: Award, title: "Award Winning", desc: "Trusted by millions worldwide" }
  ];

  return (
    <div className="min-h-screen bg-gradient-to-b from-background to-muted/20">
      {/* Hero Section */}
      <section className="container mx-auto px-4 py-20 text-center">
        <div className="max-w-4xl mx-auto space-y-8">
          <div className="inline-block px-4 py-2 bg-primary/10 rounded-full text-primary font-medium mb-4">
            🚀 Now Available in 100+ Languages
          </div>
          
          <h1 className="text-5xl md:text-7xl font-bold bg-clip-text text-transparent bg-gradient-to-r from-primary to-primary/60">
            Smart Seba
          </h1>
          
          <h2 className="text-3xl md:text-4xl font-semibold text-foreground">
            Your Intelligent AI Assistant
          </h2>
          
          <p className="text-xl text-muted-foreground max-w-2xl mx-auto">
            Experience the future of AI assistance with 14 smart modules, 100+ language support, 
            voice & video calling, and advanced AI capabilities all in one platform.
          </p>
          
          <div className="flex flex-col sm:flex-row gap-4 justify-center items-center">
            <Button 
              size="lg" 
              className="text-lg px-8 py-6 w-full sm:w-auto"
              onClick={() => navigate('/auth')}
            >
              Get Started Free
            </Button>
            <Button 
              size="lg" 
              variant="outline"
              className="text-lg px-8 py-6 w-full sm:w-auto"
              onClick={() => navigate('/chat')}
            >
              Try Demo
            </Button>
          </div>

          <div className="flex items-center justify-center gap-8 text-sm text-muted-foreground pt-8">
            <div className="flex items-center gap-2">
              <div className="w-2 h-2 rounded-full bg-green-500 animate-pulse"></div>
              <span>1M+ Active Users</span>
            </div>
            <div className="flex items-center gap-2">
              <div className="w-2 h-2 rounded-full bg-blue-500 animate-pulse"></div>
              <span>100+ Languages</span>
            </div>
            <div className="flex items-center gap-2">
              <div className="w-2 h-2 rounded-full bg-purple-500 animate-pulse"></div>
              <span>14 Smart Modules</span>
            </div>
          </div>
        </div>
      </section>

      {/* Features Section */}
      <section className="container mx-auto px-4 py-20">
        <h2 className="text-4xl font-bold text-center mb-12">Powerful Features</h2>
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
          {features.map((feature, index) => (
            <Card key={index} className="hover:shadow-lg transition-shadow">
              <CardHeader>
                <feature.icon className="w-12 h-12 text-primary mb-4" />
                <CardTitle>{feature.title}</CardTitle>
                <CardDescription>{feature.desc}</CardDescription>
              </CardHeader>
            </Card>
          ))}
        </div>
      </section>

      {/* Modules Section */}
      <section className="container mx-auto px-4 py-20 bg-muted/30 rounded-3xl">
        <h2 className="text-4xl font-bold text-center mb-4">14 Smart Modules</h2>
        <p className="text-center text-muted-foreground mb-12 max-w-2xl mx-auto">
          Everything you need in one platform - from education to healthcare, 
          e-commerce to legal services
        </p>
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-5 gap-4">
          {modules.map((module, index) => (
            <Card key={index} className="hover:shadow-xl transition-all hover:scale-105 cursor-pointer">
              <CardHeader className="text-center">
                <module.icon className="w-10 h-10 text-primary mx-auto mb-2" />
                <CardTitle className="text-lg">{module.name}</CardTitle>
                <CardDescription className="text-xs">{module.desc}</CardDescription>
              </CardHeader>
            </Card>
          ))}
        </div>
      </section>

      {/* CTA Section */}
      <section className="container mx-auto px-4 py-20 text-center">
        <Card className="max-w-3xl mx-auto bg-gradient-to-br from-primary/10 to-primary/5 border-primary/20">
          <CardContent className="pt-12 pb-12 space-y-6">
            <h2 className="text-4xl font-bold">Ready to Get Started?</h2>
            <p className="text-xl text-muted-foreground">
              Join millions of users worldwide using Smart Seba for their daily needs
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <Button 
                size="lg" 
                className="text-lg px-8 py-6"
                onClick={() => navigate('/auth')}
              >
                Create Free Account
              </Button>
              <Button 
                size="lg" 
                variant="outline"
                className="text-lg px-8 py-6"
                onClick={() => window.open('https://docs.smartseba.com', '_blank')}
              >
                View Documentation
              </Button>
            </div>
          </CardContent>
        </Card>
      </section>

      {/* Footer */}
      <footer className="border-t border-border mt-20">
        <div className="container mx-auto px-4 py-12">
          <div className="grid grid-cols-1 md:grid-cols-4 gap-8">
            <div>
              <h3 className="font-bold text-lg mb-4">Smart Seba</h3>
              <p className="text-sm text-muted-foreground">
                Your intelligent AI assistant for everything
              </p>
            </div>
            <div>
              <h4 className="font-semibold mb-4">Product</h4>
              <ul className="space-y-2 text-sm text-muted-foreground">
                <li><a href="/modules" className="hover:text-foreground">Modules</a></li>
                <li><a href="/pricing" className="hover:text-foreground">Pricing</a></li>
                <li><a href="/affiliate" className="hover:text-foreground">Affiliate</a></li>
              </ul>
            </div>
            <div>
              <h4 className="font-semibold mb-4">Company</h4>
              <ul className="space-y-2 text-sm text-muted-foreground">
                <li><a href="/about" className="hover:text-foreground">About</a></li>
                <li><a href="/blog" className="hover:text-foreground">Blog</a></li>
                <li><a href="/contact" className="hover:text-foreground">Contact</a></li>
              </ul>
            </div>
            <div>
              <h4 className="font-semibold mb-4">Legal</h4>
              <ul className="space-y-2 text-sm text-muted-foreground">
                <li><a href="/privacy" className="hover:text-foreground">Privacy Policy</a></li>
                <li><a href="/terms" className="hover:text-foreground">Terms of Service</a></li>
              </ul>
            </div>
          </div>
          <div className="border-t border-border mt-8 pt-8 text-center text-sm text-muted-foreground">
            <p>© 2024 Smart Seba. All rights reserved. Made with ❤️ for the world.</p>
          </div>
        </div>
      </footer>
    </div>
  );
}
