import { SebaHero } from "@/components/seba/SebaHero";
import { SebaModulesGrid } from "@/components/seba/SebaModulesGrid";
import { SebaFooter } from "@/components/seba/SebaFooter";
import { Button } from "@/components/ui/button";
import { useNavigate } from "react-router-dom";
import { useOwnerCheck } from "@/hooks/useOwnerCheck";
import { Shield } from "lucide-react";

export default function SebaHome() {
  const navigate = useNavigate();
  const { isOwner } = useOwnerCheck();

  return (
    <div className="min-h-screen bg-background">
      {/* Owner HQ Access Button (Fixed) */}
      {isOwner && (
        <div className="fixed bottom-6 right-6 z-50">
          <Button
            size="lg"
            className="rounded-full shadow-2xl hover:shadow-primary/50 transition-all"
            onClick={() => navigate("/hq-dashboard")}
          >
            <Shield className="w-5 h-5 mr-2" />
            HQ Dashboard
          </Button>
        </div>
      )}

      {/* Hero Section */}
      <SebaHero />

      {/* Modules Grid Section */}
      <SebaModulesGrid />

      {/* Footer */}
      <SebaFooter />
    </div>
  );
}
