import { WalletGuard } from "@/components/ide/WalletGuard";
import { Card } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";
import { GraduationCap, BookOpen, FileText, Award } from "lucide-react";

const SmartAcademy = () => {
  return (
    <WalletGuard>
      <div className="min-h-screen bg-background p-6">
        <div className="max-w-7xl mx-auto">
          <div className="flex items-center gap-3 mb-6">
            <GraduationCap className="h-8 w-8 text-primary" />
            <div>
              <h1 className="text-3xl font-bold text-foreground">Smart Academy</h1>
              <p className="text-muted-foreground">Complete learning platform with AI teacher</p>
            </div>
          </div>

          <Tabs defaultValue="classes">
            <TabsList>
              <TabsTrigger value="classes">Classes</TabsTrigger>
              <TabsTrigger value="subjects">Subjects</TabsTrigger>
              <TabsTrigger value="exams">Exams</TabsTrigger>
              <TabsTrigger value="results">My Results</TabsTrigger>
            </TabsList>

            <TabsContent value="classes" className="mt-6">
              <div className="grid grid-cols-1 md:grid-cols-3 gap-4">
                {["Class 1", "Class 2", "Class 3", "Class 4", "Class 5"].map((cls) => (
                  <Card key={cls} className="p-6 hover:border-primary transition-colors cursor-pointer">
                    <BookOpen className="h-8 w-8 text-primary mb-3" />
                    <h3 className="font-semibold text-lg mb-2">{cls}</h3>
                    <p className="text-sm text-muted-foreground mb-4">15 subjects available</p>
                    <Button size="sm" className="w-full">View Subjects</Button>
                  </Card>
                ))}
              </div>
            </TabsContent>

            <TabsContent value="subjects">
              <Card className="p-6">
                <p className="text-muted-foreground">Select a class to view subjects</p>
              </Card>
            </TabsContent>

            <TabsContent value="exams">
              <Card className="p-6">
                <div className="flex items-center gap-2 mb-4">
                  <FileText className="h-5 w-5 text-primary" />
                  <h3 className="text-lg font-semibold">Available Exams</h3>
                </div>
                <p className="text-muted-foreground">MCQ and CQ exams with AI evaluation</p>
              </Card>
            </TabsContent>

            <TabsContent value="results">
              <Card className="p-6">
                <div className="flex items-center gap-2 mb-4">
                  <Award className="h-5 w-5 text-primary" />
                  <h3 className="text-lg font-semibold">My Results</h3>
                </div>
                <p className="text-muted-foreground">Your exam results will appear here</p>
              </Card>
            </TabsContent>
          </Tabs>
        </div>
      </div>
    </WalletGuard>
  );
};

export default SmartAcademy;
