import { WalletGuard } from "@/components/ide/WalletGuard";
import { Card } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";
import { Video, FileText, Mic, BarChart } from "lucide-react";

const SmartAdFirm = () => {
  return (
    <WalletGuard>
      <div className="min-h-screen bg-background p-6">
        <div className="max-w-7xl mx-auto">
          <div className="flex items-center gap-3 mb-6">
            <Video className="h-8 w-8 text-primary" />
            <div>
              <h1 className="text-3xl font-bold text-foreground">Smart AI Ad Firm</h1>
              <p className="text-muted-foreground">AI-powered advertising and content creation</p>
            </div>
          </div>

          <Tabs defaultValue="campaigns">
            <TabsList>
              <TabsTrigger value="campaigns">Campaigns</TabsTrigger>
              <TabsTrigger value="script">Script Generator</TabsTrigger>
              <TabsTrigger value="voiceover">Voiceover</TabsTrigger>
              <TabsTrigger value="analytics">Analytics</TabsTrigger>
            </TabsList>

            <TabsContent value="campaigns" className="mt-6">
              <Card className="p-6 mb-4">
                <Button className="w-full">
                  <Video className="h-4 w-4 mr-2" />
                  Create New Ad Campaign
                </Button>
              </Card>

              <Card className="p-6">
                <h3 className="font-semibold mb-4">Recent Campaigns</h3>
                <p className="text-muted-foreground">Your ad campaigns will appear here</p>
              </Card>
            </TabsContent>

            <TabsContent value="script">
              <Card className="p-6">
                <div className="flex items-center gap-2 mb-4">
                  <FileText className="h-5 w-5 text-primary" />
                  <h3 className="text-lg font-semibold">AI Script Generator</h3>
                </div>
                <p className="text-muted-foreground mb-4">
                  Generate compelling ad scripts with AI
                </p>
                <Button>Generate Script</Button>
              </Card>
            </TabsContent>

            <TabsContent value="voiceover">
              <Card className="p-6">
                <div className="flex items-center gap-2 mb-4">
                  <Mic className="h-5 w-5 text-primary" />
                  <h3 className="text-lg font-semibold">AI Voiceover Generator</h3>
                </div>
                <p className="text-muted-foreground mb-4">
                  Create professional voiceovers with AI
                </p>
                <Button>Generate Voiceover</Button>
              </Card>
            </TabsContent>

            <TabsContent value="analytics">
              <Card className="p-6">
                <div className="flex items-center gap-2 mb-4">
                  <BarChart className="h-5 w-5 text-primary" />
                  <h3 className="text-lg font-semibold">Campaign Analytics</h3>
                </div>
                <p className="text-muted-foreground">Track your campaign performance</p>
              </Card>
            </TabsContent>
          </Tabs>
        </div>
      </div>
    </WalletGuard>
  );
};

export default SmartAdFirm;
