import { WalletGuard } from "@/components/ide/WalletGuard";
import { Card } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";
import { Store, Package, ShoppingCart, BarChart } from "lucide-react";

const SmartBazar = () => {
  return (
    <WalletGuard>
      <div className="min-h-screen bg-background p-6">
        <div className="max-w-7xl mx-auto">
          <div className="flex items-center gap-3 mb-6">
            <Store className="h-8 w-8 text-primary" />
            <div>
              <h1 className="text-3xl font-bold text-foreground">Smart Bazar</h1>
              <p className="text-muted-foreground">Multi-tenant e-commerce platform</p>
            </div>
          </div>

          <Tabs defaultValue="merchant">
            <TabsList>
              <TabsTrigger value="merchant">Merchant Dashboard</TabsTrigger>
              <TabsTrigger value="products">Products</TabsTrigger>
              <TabsTrigger value="orders">Orders</TabsTrigger>
              <TabsTrigger value="analytics">Analytics</TabsTrigger>
            </TabsList>

            <TabsContent value="merchant" className="mt-6">
              <Card className="p-6">
                <h3 className="text-lg font-semibold mb-4">Create Your Store</h3>
                <p className="text-muted-foreground mb-4">
                  Start your own online store with custom branding, domain, and product management
                </p>
                <Button>
                  <Store className="h-4 w-4 mr-2" />
                  Setup Merchant Account
                </Button>
              </Card>

              <div className="grid grid-cols-1 md:grid-cols-3 gap-4 mt-6">
                <Card className="p-6">
                  <Package className="h-8 w-8 text-primary mb-3" />
                  <h4 className="font-semibold mb-2">Products</h4>
                  <p className="text-2xl font-bold">0</p>
                </Card>
                <Card className="p-6">
                  <ShoppingCart className="h-8 w-8 text-primary mb-3" />
                  <h4 className="font-semibold mb-2">Orders</h4>
                  <p className="text-2xl font-bold">0</p>
                </Card>
                <Card className="p-6">
                  <BarChart className="h-8 w-8 text-primary mb-3" />
                  <h4 className="font-semibold mb-2">Revenue</h4>
                  <p className="text-2xl font-bold">৳0</p>
                </Card>
              </div>
            </TabsContent>

            <TabsContent value="products">
              <Card className="p-6">
                <div className="flex items-center justify-between mb-4">
                  <h3 className="text-lg font-semibold">My Products</h3>
                  <Button>Add Product</Button>
                </div>
                <p className="text-muted-foreground">Your products will appear here</p>
              </Card>
            </TabsContent>

            <TabsContent value="orders">
              <Card className="p-6">
                <h3 className="text-lg font-semibold mb-4">Recent Orders</h3>
                <p className="text-muted-foreground">Your orders will appear here</p>
              </Card>
            </TabsContent>

            <TabsContent value="analytics">
              <Card className="p-6">
                <h3 className="text-lg font-semibold mb-4">Sales Analytics</h3>
                <p className="text-muted-foreground">Analytics dashboard coming soon</p>
              </Card>
            </TabsContent>
          </Tabs>
        </div>
      </div>
    </WalletGuard>
  );
};

export default SmartBazar;
