import { WalletGuard } from "@/components/ide/WalletGuard";
import { Card } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";
import { Phone, MessageSquare, History, Ticket } from "lucide-react";

const SmartCallCenter = () => {
  return (
    <WalletGuard>
      <div className="min-h-screen bg-background p-6">
        <div className="max-w-7xl mx-auto">
          <div className="flex items-center gap-3 mb-6">
            <Phone className="h-8 w-8 text-primary" />
            <div>
              <h1 className="text-3xl font-bold text-foreground">Smart AI Call Center</h1>
              <p className="text-muted-foreground">Automated call handling with AI voice bot</p>
            </div>
          </div>

          <Tabs defaultValue="tickets">
            <TabsList>
              <TabsTrigger value="tickets">Support Tickets</TabsTrigger>
              <TabsTrigger value="history">Call History</TabsTrigger>
              <TabsTrigger value="faq">FAQ Bot</TabsTrigger>
            </TabsList>

            <TabsContent value="tickets" className="mt-6">
              <Card className="p-6 mb-4">
                <Button className="w-full">
                  <Ticket className="h-4 w-4 mr-2" />
                  Create New Ticket
                </Button>
              </Card>

              <div className="space-y-4">
                <Card className="p-6">
                  <div className="flex items-start justify-between">
                    <div className="flex-1">
                      <div className="flex items-center gap-2 mb-2">
                        <span className="px-2 py-1 bg-yellow-500/10 text-yellow-600 rounded text-xs">
                          Pending
                        </span>
                        <span className="text-sm text-muted-foreground">#T1234</span>
                      </div>
                      <h3 className="font-semibold mb-2">Technical Support Request</h3>
                      <p className="text-sm text-muted-foreground mb-3">
                        Need help with account setup...
                      </p>
                      <div className="text-xs text-muted-foreground">Created 2 hours ago</div>
                    </div>
                  </div>
                </Card>
              </div>
            </TabsContent>

            <TabsContent value="history">
              <Card className="p-6">
                <div className="flex items-center gap-2 mb-4">
                  <History className="h-5 w-5 text-primary" />
                  <h3 className="text-lg font-semibold">Call History</h3>
                </div>
                <p className="text-muted-foreground">Your call records and transcripts</p>
              </Card>
            </TabsContent>

            <TabsContent value="faq">
              <Card className="p-6">
                <div className="flex items-center gap-2 mb-4">
                  <MessageSquare className="h-5 w-5 text-primary" />
                  <h3 className="text-lg font-semibold">AI FAQ Bot</h3>
                </div>
                <p className="text-muted-foreground mb-4">
                  Get instant answers to common questions
                </p>
                <div className="space-y-2">
                  <Card className="p-3 hover:bg-muted/50 cursor-pointer">
                    <p className="text-sm">How do I reset my password?</p>
                  </Card>
                  <Card className="p-3 hover:bg-muted/50 cursor-pointer">
                    <p className="text-sm">How to upgrade my subscription?</p>
                  </Card>
                </div>
              </Card>
            </TabsContent>
          </Tabs>
        </div>
      </div>
    </WalletGuard>
  );
};

export default SmartCallCenter;
