import { useState } from "react";
import { WalletGuard } from "@/components/ide/WalletGuard";
import { Card } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";
import { Palette, Image, Download, Sparkles } from "lucide-react";

const SmartDesignHub = () => {
  const [selectedTemplate, setSelectedTemplate] = useState<string | null>(null);

  const templates = [
    { id: "1", title: "Social Media Post", category: "poster" },
    { id: "2", title: "Banner Ad", category: "banner" },
    { id: "3", title: "ID Card", category: "id_card" },
    { id: "4", title: "Business Card", category: "card" },
  ];

  return (
    <WalletGuard>
      <div className="min-h-screen bg-background p-6">
        <div className="max-w-7xl mx-auto">
          <div className="flex items-center gap-3 mb-6">
            <Palette className="h-8 w-8 text-primary" />
            <div>
              <h1 className="text-3xl font-bold text-foreground">Smart Design Hub</h1>
              <p className="text-muted-foreground">Create stunning designs with AI assistance</p>
            </div>
          </div>

          <Tabs defaultValue="templates">
            <TabsList>
              <TabsTrigger value="templates">Templates</TabsTrigger>
              <TabsTrigger value="my-designs">My Designs</TabsTrigger>
            </TabsList>

            <TabsContent value="templates" className="mt-6">
              <div className="grid grid-cols-1 md:grid-cols-3 gap-4">
                {templates.map((template) => (
                  <Card key={template.id} className="p-6 cursor-pointer hover:border-primary transition-colors">
                    <div className="aspect-video bg-muted/30 rounded-lg mb-4 flex items-center justify-center">
                      <Image className="h-12 w-12 text-muted-foreground" />
                    </div>
                    <h3 className="font-semibold text-foreground mb-2">{template.title}</h3>
                    <Button size="sm" className="w-full">
                      Use Template
                    </Button>
                  </Card>
                ))}
              </div>
            </TabsContent>

            <TabsContent value="my-designs">
              <Card className="p-6">
                <p className="text-muted-foreground">Your designs will appear here</p>
              </Card>
            </TabsContent>
          </Tabs>
        </div>
      </div>
    </WalletGuard>
  );
};

export default SmartDesignHub;
