import { WalletGuard } from "@/components/ide/WalletGuard";
import { Card } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";
import { Stethoscope, Users, Calendar, FileText } from "lucide-react";

const SmartDoctor = () => {
  const departments = [
    { name: "Cardiology", icon: "❤️" },
    { name: "Neurology", icon: "🧠" },
    { name: "Pediatrics", icon: "👶" },
    { name: "Orthopedics", icon: "🦴" },
  ];

  return (
    <WalletGuard>
      <div className="min-h-screen bg-background p-6">
        <div className="max-w-7xl mx-auto">
          <div className="flex items-center gap-3 mb-6">
            <Stethoscope className="h-8 w-8 text-primary" />
            <div>
              <h1 className="text-3xl font-bold text-foreground">Smart Doctor & Hospital</h1>
              <p className="text-muted-foreground">AI-powered healthcare management</p>
            </div>
          </div>

          <Tabs defaultValue="departments">
            <TabsList>
              <TabsTrigger value="departments">Departments</TabsTrigger>
              <TabsTrigger value="doctors">Find Doctors</TabsTrigger>
              <TabsTrigger value="appointments">My Appointments</TabsTrigger>
              <TabsTrigger value="history">Medical History</TabsTrigger>
            </TabsList>

            <TabsContent value="departments" className="mt-6">
              <div className="grid grid-cols-1 md:grid-cols-4 gap-4">
                {departments.map((dept) => (
                  <Card key={dept.name} className="p-6 text-center hover:border-primary transition-colors cursor-pointer">
                    <div className="text-4xl mb-3">{dept.icon}</div>
                    <h3 className="font-semibold mb-2">{dept.name}</h3>
                    <Button size="sm" variant="outline" className="w-full">View Doctors</Button>
                  </Card>
                ))}
              </div>
            </TabsContent>

            <TabsContent value="doctors">
              <Card className="p-6">
                <div className="flex items-center gap-2 mb-4">
                  <Users className="h-5 w-5 text-primary" />
                  <h3 className="text-lg font-semibold">Available Doctors</h3>
                </div>
                <p className="text-muted-foreground">Browse and book appointments with specialists</p>
              </Card>
            </TabsContent>

            <TabsContent value="appointments">
              <Card className="p-6">
                <div className="flex items-center gap-2 mb-4">
                  <Calendar className="h-5 w-5 text-primary" />
                  <h3 className="text-lg font-semibold">My Appointments</h3>
                </div>
                <p className="text-muted-foreground">Your appointments will appear here</p>
              </Card>
            </TabsContent>

            <TabsContent value="history">
              <Card className="p-6">
                <div className="flex items-center gap-2 mb-4">
                  <FileText className="h-5 w-5 text-primary" />
                  <h3 className="text-lg font-semibold">Medical History</h3>
                </div>
                <p className="text-muted-foreground">Your medical records and prescriptions</p>
              </Card>
            </TabsContent>
          </Tabs>
        </div>
      </div>
    </WalletGuard>
  );
};

export default SmartDoctor;
