import { WalletGuard } from "@/components/ide/WalletGuard";
import { Card } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";
import { Briefcase, FileText, Search, Users } from "lucide-react";

const SmartJob = () => {
  return (
    <WalletGuard>
      <div className="min-h-screen bg-background p-6">
        <div className="max-w-7xl mx-auto">
          <div className="flex items-center gap-3 mb-6">
            <Briefcase className="h-8 w-8 text-primary" />
            <div>
              <h1 className="text-3xl font-bold text-foreground">Smart Job</h1>
              <p className="text-muted-foreground">AI-powered job portal with CV builder</p>
            </div>
          </div>

          <Tabs defaultValue="jobs">
            <TabsList>
              <TabsTrigger value="jobs">Find Jobs</TabsTrigger>
              <TabsTrigger value="cv">CV Builder</TabsTrigger>
              <TabsTrigger value="applications">My Applications</TabsTrigger>
              <TabsTrigger value="post">Post a Job</TabsTrigger>
            </TabsList>

            <TabsContent value="jobs" className="mt-6">
              <Card className="p-6 mb-4">
                <div className="flex gap-2">
                  <input
                    type="text"
                    placeholder="Search jobs..."
                    className="flex-1 px-4 py-2 border rounded-lg"
                  />
                  <Button>
                    <Search className="h-4 w-4 mr-2" />
                    Search
                  </Button>
                </div>
              </Card>

              <div className="space-y-4">
                <Card className="p-6">
                  <div className="flex items-start justify-between">
                    <div>
                      <h3 className="text-lg font-semibold mb-2">Software Developer</h3>
                      <p className="text-muted-foreground text-sm mb-2">Tech Company Ltd.</p>
                      <p className="text-sm mb-3">Dhaka, Bangladesh • Full Time</p>
                      <p className="text-primary font-medium">৳50,000 - ৳80,000/month</p>
                    </div>
                    <Button>Apply Now</Button>
                  </div>
                </Card>
              </div>
            </TabsContent>

            <TabsContent value="cv">
              <Card className="p-6">
                <div className="flex items-center gap-2 mb-4">
                  <FileText className="h-5 w-5 text-primary" />
                  <h3 className="text-lg font-semibold">Build Your CV</h3>
                </div>
                <p className="text-muted-foreground mb-4">
                  Create a professional CV with AI assistance
                </p>
                <Button>
                  Start Building CV
                </Button>
              </Card>
            </TabsContent>

            <TabsContent value="applications">
              <Card className="p-6">
                <h3 className="text-lg font-semibold mb-4">My Applications</h3>
                <p className="text-muted-foreground">Your job applications will appear here</p>
              </Card>
            </TabsContent>

            <TabsContent value="post">
              <Card className="p-6">
                <div className="flex items-center gap-2 mb-4">
                  <Users className="h-5 w-5 text-primary" />
                  <h3 className="text-lg font-semibold">Post a Job</h3>
                </div>
                <p className="text-muted-foreground mb-4">
                  Employers can post job vacancies here
                </p>
                <Button>Create Job Posting</Button>
              </Card>
            </TabsContent>
          </Tabs>
        </div>
      </div>
    </WalletGuard>
  );
};

export default SmartJob;
