import { WalletGuard } from "@/components/ide/WalletGuard";
import { Card } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";
import { Scale, FileText, Users, MessageSquare } from "lucide-react";

const SmartLawyer = () => {
  const lawyers = [
    { name: "Advocate Rahman", specialty: "Criminal Law", experience: 15 },
    { name: "Advocate Sultana", specialty: "Family Law", experience: 10 },
    { name: "Advocate Khan", specialty: "Corporate Law", experience: 12 },
  ];

  return (
    <WalletGuard>
      <div className="min-h-screen bg-background p-6">
        <div className="max-w-7xl mx-auto">
          <div className="flex items-center gap-3 mb-6">
            <Scale className="h-8 w-8 text-primary" />
            <div>
              <h1 className="text-3xl font-bold text-foreground">Smart Lawyer</h1>
              <p className="text-muted-foreground">AI-powered legal assistance</p>
            </div>
          </div>

          <Tabs defaultValue="lawyers">
            <TabsList>
              <TabsTrigger value="lawyers">Find Lawyers</TabsTrigger>
              <TabsTrigger value="cases">My Cases</TabsTrigger>
              <TabsTrigger value="documents">Legal Documents</TabsTrigger>
              <TabsTrigger value="advisor">AI Advisor</TabsTrigger>
            </TabsList>

            <TabsContent value="lawyers" className="mt-6">
              <div className="space-y-4">
                {lawyers.map((lawyer) => (
                  <Card key={lawyer.name} className="p-6">
                    <div className="flex items-start justify-between">
                      <div className="flex gap-4">
                        <div className="w-16 h-16 bg-muted rounded-full flex items-center justify-center">
                          <Users className="h-8 w-8 text-muted-foreground" />
                        </div>
                        <div>
                          <h3 className="font-semibold text-lg">{lawyer.name}</h3>
                          <p className="text-muted-foreground text-sm mb-1">{lawyer.specialty}</p>
                          <p className="text-sm">{lawyer.experience} years experience</p>
                        </div>
                      </div>
                      <Button>Consult</Button>
                    </div>
                  </Card>
                ))}
              </div>
            </TabsContent>

            <TabsContent value="cases">
              <Card className="p-6">
                <div className="flex items-center justify-between mb-4">
                  <h3 className="text-lg font-semibold">My Cases</h3>
                  <Button>New Case</Button>
                </div>
                <p className="text-muted-foreground">Your legal cases will appear here</p>
              </Card>
            </TabsContent>

            <TabsContent value="documents">
              <Card className="p-6">
                <div className="flex items-center gap-2 mb-4">
                  <FileText className="h-5 w-5 text-primary" />
                  <h3 className="text-lg font-semibold">Legal Document Templates</h3>
                </div>
                <p className="text-muted-foreground mb-4">
                  Access various legal document templates
                </p>
                <div className="space-y-2">
                  <Card className="p-3 hover:bg-muted/50 cursor-pointer">
                    <p className="font-medium">Rental Agreement</p>
                  </Card>
                  <Card className="p-3 hover:bg-muted/50 cursor-pointer">
                    <p className="font-medium">Power of Attorney</p>
                  </Card>
                  <Card className="p-3 hover:bg-muted/50 cursor-pointer">
                    <p className="font-medium">Partnership Deed</p>
                  </Card>
                </div>
              </Card>
            </TabsContent>

            <TabsContent value="advisor">
              <Card className="p-6">
                <div className="flex items-center gap-2 mb-4">
                  <MessageSquare className="h-5 w-5 text-primary" />
                  <h3 className="text-lg font-semibold">AI Legal Advisor</h3>
                </div>
                <p className="text-muted-foreground mb-4">
                  Get AI-powered legal suggestions and guidance
                </p>
                <Button>Ask AI Advisor</Button>
              </Card>
            </TabsContent>
          </Tabs>
        </div>
      </div>
    </WalletGuard>
  );
};

export default SmartLawyer;
