import { WalletGuard } from "@/components/ide/WalletGuard";
import { Card } from "@/components/ui/card";
import { Badge } from "@/components/ui/badge";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";
import { Newspaper, TrendingUp, Globe } from "lucide-react";

const SmartNews = () => {
  const categories = ["Politics", "Technology", "Sports", "Entertainment", "Business", "Health"];

  return (
    <WalletGuard>
      <div className="min-h-screen bg-background p-6">
        <div className="max-w-7xl mx-auto">
          <div className="flex items-center gap-3 mb-6">
            <Newspaper className="h-8 w-8 text-primary" />
            <div>
              <h1 className="text-3xl font-bold text-foreground">Smart News</h1>
              <p className="text-muted-foreground">AI-powered news aggregator with summaries</p>
            </div>
          </div>

          <div className="flex gap-2 mb-6 flex-wrap">
            {categories.map((cat) => (
              <Badge key={cat} variant="outline" className="cursor-pointer hover:bg-primary hover:text-primary-foreground">
                {cat}
              </Badge>
            ))}
          </div>

          <Tabs defaultValue="trending">
            <TabsList>
              <TabsTrigger value="trending">Trending</TabsTrigger>
              <TabsTrigger value="latest">Latest</TabsTrigger>
              <TabsTrigger value="international">International</TabsTrigger>
            </TabsList>

            <TabsContent value="trending" className="mt-6">
              <div className="space-y-4">
                <Card className="p-6">
                  <div className="flex items-start gap-4">
                    <div className="w-32 h-32 bg-muted rounded-lg flex-shrink-0" />
                    <div className="flex-1">
                      <div className="flex items-center gap-2 mb-2">
                        <TrendingUp className="h-4 w-4 text-primary" />
                        <Badge>Trending</Badge>
                      </div>
                      <h3 className="text-lg font-semibold mb-2">Breaking News Title</h3>
                      <p className="text-muted-foreground text-sm mb-3">
                        AI-generated summary of the news article...
                      </p>
                      <div className="text-xs text-muted-foreground">2 hours ago</div>
                    </div>
                  </div>
                </Card>
              </div>
            </TabsContent>

            <TabsContent value="latest">
              <Card className="p-6">
                <p className="text-muted-foreground">Latest news will appear here</p>
              </Card>
            </TabsContent>

            <TabsContent value="international">
              <Card className="p-6">
                <div className="flex items-center gap-2 mb-4">
                  <Globe className="h-5 w-5 text-primary" />
                  <h3 className="text-lg font-semibold">International News</h3>
                </div>
                <p className="text-muted-foreground">Global news stories</p>
              </Card>
            </TabsContent>
          </Tabs>
        </div>
      </div>
    </WalletGuard>
  );
};

export default SmartNews;
